package prototyp;

import java.util.List;
import java.util.ArrayList;
import framework.Schiedsrichter;
import framework.Spiel;
import framework.Spielbrett;
import framework.Interpreter;
import framework.Spieler;
import framework.Spielfeld;
import framework.Spielzug;
import framework.MessageDialog;
import framework.Figur;

public class TicTacToeSchiedsrichter implements Schiedsrichter {
  
    private Spiel spiel;
    private Spielbrett brett;
    private Spieler sieger;
    private Interpreter interpreter;

    public TicTacToeSchiedsrichter() {
        this.spiel = null;
	this.brett = new SpielbrettImpl(this);
	this.sieger = null;
	this.interpreter = new TicTacToeInterpreter(this);
    }

    public Schiedsrichter kopiere() {
        Schiedsrichter kopie = new TicTacToeSchiedsrichter();
        kopie.setSpiel() = this.spiel;
        kopie.setBrett() = this.brett;
    }

    public void setBrett(Spielbrett brett) {
	this.brett = brett;
    }
    
    public Spielbrett getBrett() {
	return this.brett;
    }

    public void setSpiel(Spiel spiel) {
	this.spiel = spiel;
    }

    public Spiel getSpiel() {
	return this.spiel;
    }

    public Interpreter getInterpreter() {
	return this.interpreter;
    }
    
    public Spieler ermittleSpieler(Spieler vorherigerSpieler) {
	Spieler spielerA = this.spiel.getSpielerA();
	Spieler spielerB = this.spiel.getSpielerB();
	if (vorherigerSpieler == null 
            || vorherigerSpieler.equals(spielerB)) {
	    return spielerA;
	} else {
	    return spielerB;
	}
    }
	         
    public void fuehreZugAus(Spielzug zug, Spieler spieler) {
        Spielfeld feld = zug.getZiel();
        this.brett.weiseZu(feld, new FigurImpl(spieler, feld));
    }
    
    public boolean zugKorrekt(Spielzug pruefZug, Spieler spieler) {
        if (pruefZug == null) {
            this.sieger = (spieler.istSpielerA())
	                    ? this.spiel.getSpielerB()
			    : this.spiel.getSpielerA();
            MessageDialog dialog = this.spiel.getMessageDialog();
            dialog.gebeAus("Zug ist null");
            return false;
	}
	for (Spielzug zug : getAlleZuege(spieler)) {
	    if (pruefZug.equals(zug)) {
		return true;
	    }
	}
        this.sieger = (spieler.istSpielerA())
                        ? this.spiel.getSpielerB()
	       	        : this.spiel.getSpielerA();
        MessageDialog dialog = this.spiel.getMessageDialog();
        dialog.gebeAus("Zug ist null");
	return false;
    }
  
    public Spielzug[] getAlleZuege(Spieler spieler) {
        List<Spielzug> zuege = new ArrayList<Spielzug>();
        for (Spielfeld feld : this.brett.getFelder()) {
            if (feld.getFigur() == null) {
                zuege.add (new SpielzugImpl(feld));
            }
        }
        return zuege.toArray(new Spielzug[zuege.size()]);
    }

    public boolean spielBeendet() {
        this.sieger = diagonaleVorhanden();
	if (this.sieger != null) {
	    return true;
	}
	this.sieger = reiheVorhanden();
	if (this.sieger != null) {
	    return true;
	}
        this.sieger = spalteVorhanden();
	if (this.sieger != null) {
	    return true;
	}
        for (Spielfeld feld : this.brett.getFelder()) {
	    if (feld.getFigur() == null) {
		return false;
	    }
	}
	return true;
    }

    private Spieler reiheVorhanden() {
	Figur aktuelleFigur;
        SpielbrettImpl brettImpl = (SpielbrettImpl) this.brett;
        for (int i = 0; i < 3; i++) {
            int zaehler = 0;
            for (int j = 0; j < 3; j++) {
                aktuelleFigur = brettImpl.getFeld(i, j).getFigur();
                if (aktuelleFigur != null) {
                    if(aktuelleFigur.getSpieler().istSpielerA()) {
			zaehler++;
		    } else {
			zaehler--;
		    }
                }
	    }
	    if (zaehler == 3) {
		return this.spiel.getSpielerA();
	    } else if (zaehler == -3) {
		return this.spiel.getSpielerB();
	    } 
	}
        return null;	
    }

    private Spieler spalteVorhanden() {
	Figur aktuelleFigur;
        SpielbrettImpl brettImpl = (SpielbrettImpl) this.brett;
        for (int i = 0; i < 3; i++) {
            int zaehler = 0;
            for (int j = 0; j < 3; j++) {
                aktuelleFigur = brettImpl.getFeld(j, i).getFigur();
                if (aktuelleFigur != null) {
                    if(aktuelleFigur.getSpieler().istSpielerA()) {
			zaehler++;
		    } else {
			zaehler--;
		    }
                }
	    }
	    if (zaehler == 3) {
		return this.spiel.getSpielerA();
	    } else if (zaehler == -3) {
		return this.spiel.getSpielerB();
	    } 
	}
        return null;	
    }    
    
    private Spieler diagonaleVorhanden() {
	int zaehler1 = 0;
	int zaehler2 = 0;
	Figur aktuelleFigur;
        SpielbrettImpl brettImpl = (SpielbrettImpl) this.brett;
	for (int i = 0; i < 3; i++) {
            aktuelleFigur = brettImpl.getFeld(i, i).getFigur();
            if (aktuelleFigur != null) {
                if (aktuelleFigur.getSpieler().istSpielerA()) {
		    zaehler1++;
		} else {
		    zaehler1--;
		}
            }
            aktuelleFigur = brettImpl.getFeld(i, 2 - i).getFigur();
            if (aktuelleFigur != null) {
                if (aktuelleFigur.getSpieler().istSpielerA()) {
		    zaehler2++;
		} else {
		    zaehler2--;
		}
            }
	}
        if (zaehler1 == 3 || zaehler2 == 3) {
	    return this.spiel.getSpielerA();
	} else if (zaehler1 == -3 || zaehler2 == -3) {
	    return this.spiel.getSpielerB();
	} else { //keine Diagonale vorhanden
	    return null;
	}
    }
	  
    public void verkuendeSieger() {
        MessageDialog dialog = this.spiel.getMessageDialog();
        if (sieger != null) {
	    dialog.gebeAus(sieger.toString() + " ist Sieger!");
	} else {
	    dialog.gebeAus("Das Spiel geht unentschieden zu Ende!");
	}
    }
}
