package prototyp;

import framework.Interpreter;
import framework.Schiedsrichter;
import framework.Spielzug;

public class TicTacToeInterpreter implements Interpreter {

    private Schiedsrichter richter;
    
    public TicTacToeInterpreter(Schiedsrichter richter) {
        this.richter = richter;
    }
    
    public Spielzug getZug(String str) {
        char c = str.charAt(0);
        SpielbrettImpl brettImpl = 
                (SpielbrettImpl) this.richter.getBrett();
        switch (c) {
        case '1':
            return new SpielzugImpl(brettImpl.getFeld (2, 0));
        case '2':
            return new SpielzugImpl(brettImpl.getFeld (2, 1));
        case '3':
            return new SpielzugImpl(brettImpl.getFeld (2, 2));
        case '4':
            return new SpielzugImpl(brettImpl.getFeld (1, 0));
        case '5':
            return new SpielzugImpl(brettImpl.getFeld (1, 1));
        case '6':
            return new SpielzugImpl(brettImpl.getFeld (1, 2));
        case '7':
            return new SpielzugImpl(brettImpl.getFeld (0, 0));
        case '8':
            return new SpielzugImpl(brettImpl.getFeld (0, 1));
        case '9':
            return new SpielzugImpl(brettImpl.getFeld (0, 2));    
        }
        return null;
    }        
}

