package prototyp;

import framework.Spieler;
import framework.Figur;
import framework.Spiel;
import framework.InputDialog;
import framework.Interpreter;
import framework.Spielzug;

public class SpielerImpl implements Spieler {

    private boolean istSpielerA;
    private Spiel spiel;
    private Figur[] figuren;

    public SpielerImpl(boolean istSpielerA) {
	this.istSpielerA = istSpielerA;
	this.figuren = null;
    }

    public boolean istSpielerA() {
	return istSpielerA;
    }

    public Spiel getSpiel() {
	return this.spiel;
    }

    public void setSpiel(Spiel spiel) {
	this.spiel = spiel;
    }

    public Figur[] getFiguren() {
	return this.figuren;
    }

    public void setFiguren(Figur[] figuren) {
	this.figuren = figuren;
    }
   
    public Spielzug getZug() {
	InputDialog dialog = this.spiel.getInputDialog();
	Interpreter interpreter = this.spiel.getRichter().getInterpreter();
	String eingabe = dialog.getEingabe(toString() + 
	                                   ", geben Sie bitte Ihren Zug ein.");
        return interpreter.getZug(eingabe);
    }	
    
    public String toString() {
	return (istSpielerA) ? "Spieler A" : "Spieler B";
    }
    
    public boolean equals(Object obj) {
	if (obj == null) {
	    return false;
	}
	if (!(obj instanceof Spieler)) {
	    return false;
	}
	Spieler andererSpieler = (Spieler) obj;
	if (this.istSpielerA == andererSpieler.istSpielerA()) {
	    return true;
	}
	return false;	    
    }
}
