package prototyp;

import framework.SpielbrettView;
import framework.Spielbrett;
import framework.Spielfeld;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class SpielbrettViewImpl implements SpielbrettView {

    private Hamster[] belegung;

    public SpielbrettViewImpl() {
        this.belegung = new Hamster[9];
    }

    public void aktualisiere(Spielbrett brett) {
        Spielfeld[] felder = brett.getFelder();
        for (int i = 0; i < this.belegung.length; i++) {
            SpielfeldImpl feldImpl = (SpielfeldImpl) felder[i];
            if (feldImpl.getFigur() != null && belegung[i] == null) {
                int reihe = feldImpl.getReihe();
                int spalte = feldImpl.getSpalte();
                int blick = (feldImpl.getFigur().getSpieler().istSpielerA())
                               ? Hamster.NORD
                               : Hamster.SUED;
                Hamster hamster = new Hamster(reihe, spalte, blick, 0);
                belegung[i] = hamster;
            }                
        }       
    }
}