package prototyp;

import framework.Spielbrett;
import framework.Sender;
import framework.Spielfeld;
import framework.Schiedsrichter;
import framework.Figur;

public class SpielbrettImpl extends Sender implements Spielbrett {
    
    private Schiedsrichter richter;
    private Spielfeld[] felder;

    public SpielbrettImpl(Schiedsrichter richter) {
	this.richter = richter;
	this.felder = new Spielfeld[9];
	int zaehler = 0;
	for (int i = 0; i < 3; i++) {
	    for (int j = 0; j < 3; j++) {
		Spielfeld feld = new SpielfeldImpl(this, i, j);
		this.felder[zaehler] = feld;
		zaehler++;
	    }
	}
    }

    public void setRichter(Schiedsrichter richter) {
	this.richter = richter;
    }

    public Schiedsrichter getRichter() {
	return this.richter;
    }
    
    public void setFelder(Spielfeld[] felder) {
	this.felder = felder;
    }
    
    public Spielfeld[] getFelder() {
	return this.felder;
    }

    public Spielfeld getFeld(int reihe, int spalte) {        
	for (Spielfeld feld : this.felder) {
            SpielfeldImpl feldImpl = (SpielfeldImpl) feld;
	    if (feldImpl.getReihe() == reihe 
	            && feldImpl.getSpalte() == spalte) {
		return feldImpl;
	    }
	}
	return null;
    }

    public void weiseZu(Spielfeld feld, Figur figur) {
	if (gehoertDazu(feld)) {
	    feld.setFigur(figur);
	    if (figur != null) {
		figur.setFeld(feld);
	    }
	}
	benachrichtige();
    }
	
    public void wandleUm(Figur alteFigur, Figur neueFigur) {
	if (alteFigur != null && neueFigur != null) {
	    weiseZu(alteFigur.getFeld(), neueFigur);
	    alteFigur.setFeld(null);
	}
	benachrichtige();
    }
    
    public void initialisiere() { }	
    
    public boolean gehoertDazu(Spielfeld pruefFeld) {
        if (pruefFeld == null) {
	    return false;
	}
	for (Spielfeld feld : this.felder) {
	    if (pruefFeld.equals(feld)) {
		return true;
	    }
	}
	return false;
    }
}
