package prototyp;

import java.util.List;
import java.util.ArrayList;
import framework.Spiel;
import framework.Spieler;
import framework.Schiedsrichter;
import framework.SpielbrettView;
import framework.InputDialog;
import framework.MessageDialog;
import framework.Figur;
import framework.Spielzug;

public class SpielImpl implements Spiel {

    private Spieler spielerA;
    private Spieler spielerB;
    private Schiedsrichter richter;
    private SpielbrettView view;
    private InputDialog inputDialog;
    private MessageDialog messageDialog;

    public SpielImpl(Spieler spielerA, Spieler spielerB, 
                     Schiedsrichter richter, SpielbrettView view,
		     InputDialog inputDialog, MessageDialog messageDialog) {

	this.spielerA = spielerA;
        this.spielerA.setSpiel(this);
        this.spielerB = spielerB;
        this.spielerB.setSpiel(this);
        this.richter = richter;
        this.richter.setSpiel(this);
	this.inputDialog = inputDialog;
	this.messageDialog = messageDialog;

	this.view = view;     
        richter.getBrett().meldeAn(view);
    }

    public Spieler getSpielerA() {
        return this.spielerA;
    }

    public Spieler getSpielerB() {
        return this.spielerB;
    }

    public Schiedsrichter getRichter() {
	return this.richter;
    }
    
    public InputDialog getInputDialog() {
	return this.inputDialog;
    }
    
    public MessageDialog getMessageDialog() {
	return this.messageDialog;
    }

    public void steuereAblauf() {
        Spieler aktuellerSpieler = null;
        Figur figur;
        Spielzug zug;
        boolean zugKorrekt;   
        this.messageDialog.gebeAus("Willkommen beim TicTacToe-Spiel!");
        do {
            aktuellerSpieler = 
                    this.richter.ermittleSpieler(aktuellerSpieler);
            zug = aktuellerSpieler.getZug();
            if (!richter.zugKorrekt(zug, aktuellerSpieler)) {
		break;
            }
            richter.fuehreZugAus(zug, aktuellerSpieler);
        } while (!(richter.spielBeendet()));
        richter.verkuendeSieger();
    }
}


