package hamsterView;

import java.util.Map;
import java.util.HashMap;

import framework.Spielbrett;
import framework.Spielfeld;
import framework.Figur;
import framework.KoordinatenSpielfeld;
import framework.SpielbrettView;
import framework.Schiedsrichter;

import dame.DameStein;
import dame.DameDame;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class HamsterDameView implements SpielbrettView {

    private String[] bilder;
    private Map<Figur, HamsterFigur> hamsterFiguren;
    public static final String[] moeglicheSpiele = { "Dame" };

    public HamsterDameView(Schiedsrichter richter) {
        boolean darstellbar = false;
        for (String str : moeglicheSpiele) {
             if (richter.toString().equals(str)) {
                 darstellbar = true;
             }
        }
        if (!darstellbar) {
            throw new RuntimeException();
        }
        this.hamsterFiguren = 
            new HashMap<Figur, HamsterFigur>();
        //Zuschauer:
        Hamster julien = new Hamster(0, 1, Hamster.SUED, 0);
        Hamster dick = new Hamster(1, 0, Hamster.OST, 0);
        Hamster george = new Hamster(0, 2, Hamster.SUED, 0);
        Hamster ann = new Hamster(2, 0, Hamster.OST, 0);
        Hamster timmyDerHun = new Hamster(0, 3, Hamster.SUED, 0);
    }

    public void aktualisiere(Spielbrett brett) {
        Spielfeld[] felder = brett.getFelder();
        boolean neuerHamster = false;
        for (int i = 0; i < felder.length; i++) {
            Figur figur = felder[i].getFigur();
            if (figur != null) {
                int x = ((KoordinatenSpielfeld) felder[i]).getReihe();
                int y = ((KoordinatenSpielfeld) felder[i]).getSpalte();
                if (!hamsterFiguren.containsKey(figur)) {
                    Hamster[] alleHamster = 
                        Territorium.getHamster(x + 2, y + 2);
                    HamsterFigur hamster = null;
                    if (alleHamster == null || alleHamster.length < 1) {         
                        int blick = (figur.getSpieler().istSpielerA()) 
                                      ? Hamster.NORD 
                                      : Hamster.SUED;
                        hamster = new HamsterFigur(x + 2, y + 2, blick, 0);
                        hamsterFiguren.put(figur, hamster);
                        neuerHamster = true;
                    } else {
                        hamster = (HamsterFigur) alleHamster[0];
                        hamster.linksUm();
                        hamsterFiguren.put(figur, hamster);            
                    }  
                } else {
                    HamsterFigur hamster = hamsterFiguren.get(figur);
                    if (x != hamster.getReihe() - 2 
                        || y != hamster.getSpalte() - 2) {
                        hamster.bewege (x + 2, y + 2);
                    }
                }
            }
        }
        if (!neuerHamster) {
            for (int i = 0; i < felder.length; i++) {
                Figur figur = felder[i].getFigur();
                if (figur == null) {
                    int x = 
                        ((KoordinatenSpielfeld) felder[i]).getReihe();
                    int y = 
                        ((KoordinatenSpielfeld) felder[i]).getSpalte();
                    Hamster[] alleHamster = 
                        Territorium.getHamster(x + 2, y + 2);
                    HamsterFigur hamster = null;
                    if (alleHamster != null && alleHamster.length > 0) {
                        hamster = (HamsterFigur) alleHamster[0];
                    }
                    if (hamster != null) {
                        hamster.bewege(11, 11);
                    }        
                }
            }
        }
    }
}