package framework;

public class ZweierSpielzug extends WertSpielzug {

    private Spielfeld start;
    private Spielfeld ziel;

    public ZweierSpielzug(Spielfeld start, Spielfeld ziel) {
        this.start = start;
        this.ziel = ziel;
    }

    public Spielfeld getStart() {
        return this.start;
    }     

    public Spielfeld getZiel() {
        return this.ziel;
    }

    public Spielfeld[] getFelder() {
        Spielfeld[] felder = { this.start, this.ziel };
        return felder;    
    }

    public String toString() {
        return this.start.toString() + ", " + this.ziel.toString();
    }

    public boolean equals (Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spielzug)) {
            return false;
        }
        Spielzug andererZug = (Spielzug) obj;
        if (andererZug.getFelder().length != 2) {
            return false;
        }
        Spielfeld andererStart = andererZug.getStart();
        Spielfeld anderesZiel = andererZug.getZiel();
        if (this.start == null && andererStart == null) {
            if (this.ziel == null && anderesZiel == null) {
                return true;
            }
            if (this.ziel != null && anderesZiel != null 
                && this.ziel.equals (anderesZiel)) {
                return true;
            }
            return false;
        } else if (this.start != null && andererStart != null 
                   && this.start.equals (andererStart)) {
            if (this.ziel == null && anderesZiel == null) {
                return true;
            }
            if (this.ziel != null && anderesZiel != null 
                && this.ziel.equals (anderesZiel)) {
                return true;
            }
            return false;
        }
        return false;
    } 
}
