package framework;

import java.util.ArrayList;
import java.util.List;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class SpielzugInterpreter implements Interpreter {

    private Schiedsrichter richter;
  
    public SpielzugInterpreter(Schiedsrichter richter) {
        this.richter = richter;
    }

    public Spielzug getZug(String str) {
        if (str == null) {
            return null;
        }
        LinkedList<Spielfeld> list = new LinkedList<Spielfeld>();
        StringTokenizer tokenizer = 
                new StringTokenizer(str, ",;.:-_\t\n\r\f+*~#'?!/$%&=");
        Spielfeld[] felder = richter.getBrett().getFelder();

        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            boolean korrekt = false;
            for (Spielfeld feld : felder) {
                if (token.equals(feld.toString())) {
                    list.add(feld);
                    korrekt = true;
                    break;
                }
            }
            if (!korrekt) {
                return null;
            }
        }
        if (list.size() == 1) {
            return new EinerSpielzug(list.get(0));
        } else if (list.size() > 2) {
            return new PolySpielzug(list);
        } else {
            return new ZweierSpielzug(list.get(0), list.get(1));
        }
    }
}

