package framework;

import java.util.LinkedList;

public class PolySpielzug extends WertSpielzug {

    private LinkedList<Spielfeld> list;

    public PolySpielzug() {
        this.list = new LinkedList<Spielfeld>();
    }

    public PolySpielzug(Spielfeld start) {
        this.list = new LinkedList<Spielfeld>();
        this.list.add (start);
    }

    public PolySpielzug(LinkedList<Spielfeld> list) {
        this.list = list;
    }

    public Spielfeld getStart() {
        return (this.list.size() != 0) 
                 ? (Spielfeld) this.list.getFirst() 
                 : null;
    }     

    public Spielfeld getZiel() {
        return (this.list.size() != 0) 
                  ? (Spielfeld) this.list.getLast() 
                  : null;
    }

    public Spielfeld[] getFelder() {
        return this.list.toArray(new Spielfeld[this.list.size()]);
    }

    public void erweitere(Spielfeld spielfeld) {
        this.list.add(spielfeld);
    }

    public String toString() {
        String erg = "";
        for (Spielfeld feld : list) {
            erg += " " + feld.toString() + ", ";
        }
        erg = erg.substring(0, erg.length() - 2);
        return erg;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spielzug)) {
            return false;
        }
        Spielzug zug = (Spielzug) obj;
        int length_a = zug.getFelder().length;
        int length_b = this.getFelder().length;
        if (length_a  != length_b) {
            return false;
        }
        for (int i = 0; i < zug.getFelder().length; i++) {
            if (zug.getFelder()[i] != null) {
                if (!(zug.getFelder()[i].equals(this.getFelder()[i]))) {
                    return false;
                }
            } else {
                if (this.getFelder()[i] != null) {
                    return false;
                }
            }
        }
        return true;
    }
}
