package framework;

public class MinimaxSpielerFabrik implements SpielerFabrik {

    public Spieler erzeugeSpieler(boolean istSpielerA, 
                                  FabrikParameter parameter) {
        if (parameter == null) {
            return null;
        }
        Integer tiefe = parameter.getIntParam("tiefe");
        Bewertung bewertung = parameter.getBewertungParam("bewertung");
        if (tiefe == null || bewertung == null) {
            throw new IllegalArgumentException();
        }
        return new MinimaxSpieler(istSpielerA, tiefe, bewertung);
    }
}

