package framework;

import java.util.ArrayList;

public class MinimaxSpieler extends AbstrakterSpieler {

    public final static int MINIMUM = - 1000000;
    public final static int MAXIMUM = 1000000;

    private int spielStaerke;
    private Bewertung bewertung;

    public MinimaxSpieler(boolean istSpielerA, int spielStaerke, 
                          Bewertung bewertung) {
        super(istSpielerA);
        this.spielStaerke = spielStaerke;
        this.bewertung = bewertung;
    }

    public Spielzug getZug() {
        Schiedsrichter richter = this.spiel.getRichter();
        Spielbrett brett = richter.getBrett();
        Spielzug naechsterZug = null;
        if (this.istSpielerA()) {
            naechsterZug = maxWert(this.spielStaerke, brett, richter);
        } else {
            naechsterZug = minWert(this.spielStaerke, brett, richter);
        }
        PolySpielzug poly = new PolySpielzug();
        for (Spielfeld feld : naechsterZug.getFelder()) {
            poly.erweitere(
                transformiere(feld, feld.getBrett(), richter.getBrett())
            );            
        }
        return poly;
    }

    public WertSpielzug maxWert(int restTiefe, Spielbrett brett, 
                            Schiedsrichter richter) {
        int ermittelt = MINIMUM;
        WertSpielzug besterZug = null;
        Spielzug[] moeglicheSpielzuege = 
                richter.getAlleZuege(this.spiel.getSpielerA());
        for (Spielzug z : moeglicheSpielzuege) {
            Schiedsrichter kopie = richter.kopiere();
            PolySpielzug poly = new PolySpielzug();
            for (Spielfeld feld : z.getFelder()) {
                poly.erweitere(
                    transformiere(feld, richter.getBrett(), kopie.getBrett())
                );
            }
            kopie.fuehreZugAus(poly, spiel.getSpielerA());
            int zugWert = 0;
            if (restTiefe <= 1 
                || keinZugMoeglich(kopie, spiel.getSpielerA())) {
                zugWert = bewertung.analysiere(kopie.getBrett());
            } else {
                WertSpielzug zug = 
                    minWert(restTiefe - 1, kopie.getBrett(), kopie);
                zugWert = (zug != null) ? zug.getWert() : 0;
            }
            int zufall = (int) (Math.random() * 2);
            if (zugWert > ermittelt 
                || (zugWert == ermittelt && zufall == 0)) {
                ermittelt = zugWert;
                besterZug = poly;
                besterZug.setWert(zugWert);
            }
        }
        return besterZug;
    }
  
    public WertSpielzug minWert(int restTiefe, Spielbrett brett, 
                            Schiedsrichter richter) {
        int ermittelt = MAXIMUM;
        WertSpielzug besterZug = null;
        Spielzug[] moeglicheSpielzuege = 
                richter.getAlleZuege(this.spiel.getSpielerB());
        for (Spielzug z : moeglicheSpielzuege) {
            Schiedsrichter kopie = richter.kopiere();
            PolySpielzug poly = new PolySpielzug();
            for (Spielfeld feld : z.getFelder()) {
                poly.erweitere(
                    transformiere(feld, richter.getBrett(), kopie.getBrett())
                );
            }
            kopie.fuehreZugAus(poly, spiel.getSpielerB());
            int zugWert = 0;
            if (restTiefe <= 1 
                || keinZugMoeglich(kopie, spiel.getSpielerB())) {
                zugWert = bewertung.analysiere(kopie.getBrett());
            } else {
              WertSpielzug zug = 
                  maxWert(restTiefe - 1, kopie.getBrett(), kopie);
              zugWert = (zug != null) ? zug.getWert() : 0;
            }
            int zufall = (int) (Math.random() * 2);
            if (zugWert < ermittelt 
                || (zugWert == ermittelt && zufall == 0)) {
                ermittelt = zugWert;
                besterZug = poly;
                besterZug.setWert(zugWert);
            }
        }
        return besterZug;
    }

    public boolean keinZugMoeglich(Schiedsrichter richter, 
                                   Spieler spieler) {
        if (richter.getAlleZuege(spieler) != null
                && richter.getAlleZuege(spieler).length > 1) {
            return false;
        }
        return true;
    }

    private KoordinatenSpielfeld transformiere(Spielfeld feld, 
                                               Spielbrett brett, 
                                               Spielbrett kopie) {
        KoordinatenSpielfeld[] felder = 
                new KoordinatenSpielfeld[kopie.getFelder().length];
        for (int i = 0; i < kopie.getFelder().length; i++) {
            felder[i] = (KoordinatenSpielfeld) kopie.getFelder()[i];
        }
        for (KoordinatenSpielfeld f : felder) {
            if (f.getReihe() == ((KoordinatenSpielfeld)feld).getReihe() 
              && f.getSpalte() == ((KoordinatenSpielfeld)feld).getSpalte()) {
                return f;
            }
        }
        return null;
    }
}

