package framework;

public class KoordinatenSpielfeld extends DefaultSpielfeld {

    private int reihe;
    private int spalte;

    public KoordinatenSpielfeld(Spielbrett brett, int reihe, int spalte) {
        super(brett);
        if (!(brett instanceof KoordinatenSpielbrett)) {
            throw new IllegalArgumentException();
        }
        this.reihe = reihe;
        this.spalte = spalte;
    }

    public int getReihe() {
        return this.reihe;
    }

    public int getSpalte() {
        return this.spalte;
    }

    public String toString() {
        String x = new Integer(this.reihe + 1).toString();
        char y;
        if (spalte < 26) {
            y = (char) (this.spalte + 97);
        } else {
            y = (char) (this.spalte + 39);
        }
        return y + x;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KoordinatenSpielfeld)) {
            return false;
        }
        KoordinatenSpielfeld anderesFeld = (KoordinatenSpielfeld) obj;
        if (this.reihe == anderesFeld.getReihe() 
            && this.spalte == anderesFeld.getSpalte()) {
            return true;
        }
        return false;
    }  
}
