package framework;

import java.util.ArrayList;
import java.util.List;

abstract public class KoordinatenSpielbrett extends DefaultSpielbrett {

    protected int reihen;
    protected int spalten;

    public KoordinatenSpielbrett(Schiedsrichter richter, 
                                 int reihen, int spalten) {
        super(richter);
        List<Spielfeld> list = new ArrayList<Spielfeld>();
        for (int i = 0; i < reihen; i++) {
            for (int j = 0; j < spalten; j++) {
                list.add (new KoordinatenSpielfeld (this, i, j));
            }
        }
        this.felder = list.toArray(new KoordinatenSpielfeld[list.size()]);
        this.reihen = reihen;
        this.spalten = spalten;
    }

    public KoordinatenSpielfeld sucheFeld(int reihe, int spalte) {
        for (Spielfeld feld : this.felder) {
            KoordinatenSpielfeld xyfeld = (KoordinatenSpielfeld) feld;
            if (xyfeld.getReihe() == reihe 
                    && xyfeld.getSpalte() == spalte) {
                return xyfeld;
            }
        }
        return null;
    }
}

