package framework;

public class EinerSpielzug extends WertSpielzug {

    private Spielfeld feld;

    public EinerSpielzug(Spielfeld feld) {
        this.feld = feld;
    }

    public Spielfeld getStart() {
        return this.feld;
    }

    public Spielfeld getZiel() {
        return this.feld;
    }

    public Spielfeld[] getFelder() {
        Spielfeld[] felder = { this.feld };
        return felder;
    }

    public String toString() {
        return "EinerSpielzug: " + this.feld;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spielzug)) {
            return false;
        }
        Spielzug andererZug = (Spielzug) obj;
        if (andererZug.getFelder().length != 1) {
            return false;
        }
        if (this.feld.equals(andererZug.getFelder()[0])) {
            return true;
        }
        return false;
    }  
}

