package framework;

abstract public class DefaultSpielbrett extends Sender 
                                        implements Spielbrett {

    protected Spielfeld[] felder;
    protected Schiedsrichter richter;

    public DefaultSpielbrett(Schiedsrichter richter) {
        super();
        this.richter = richter;
    }

    public Schiedsrichter getRichter() {
        return this.richter;
    }

    public void setRichter(Schiedsrichter richter) {
        this.richter = richter;
    }

    public Spielfeld[] getFelder() {
        return this.felder;
    }

    public void setFelder(Spielfeld[] felder) {
        this.felder = felder;
    }

    public void weiseZu(Spielfeld feld, Figur figur) {
        if (figur != null && figur.getFeld() != feld) {
            figur.getFeld().setFigur(null);
        }
        feld.setFigur(figur);
        if (figur != null) {
            figur.setFeld(feld);
        }
        benachrichtige();
    }

    public void wandleUm(Figur alteFigur, Figur neueFigur) {
        Spielfeld feld = alteFigur.getFeld();
        alteFigur.setFeld(null);
        feld.setFigur(neueFigur);
        neueFigur.setFeld(feld);
        benachrichtige();
    }

    public boolean gehoertDazu(Spielfeld pruefFeld) {
        if (pruefFeld == null) {
            return false;
        }
        for (Spielfeld feld : this.felder) {
            if (pruefFeld.equals(feld)) {
                return true;
            }
        }
        return false;
    }
    public void initialisiere() { }
}

