package framework;

public class DefaultSpielFabrik implements SpielFabrik {

    public Spiel erzeugeSpiel(MessageDialog messageDialog,
                              InputDialog inputDialog,
                              SchiedsrichterFabrik schiedsrichterFabrik,
                              SpielbrettViewFabrik spielbrettViewFabrik,
                              SpielerFabrik spielerFabrikA,
                              FabrikParameter parameterA,
                              SpielerFabrik spielerFabrikB,
                              FabrikParameter parameterB) {

        Schiedsrichter richter = 
                schiedsrichterFabrik.erzeugeSchiedsrichter();
        
        
        SpielbrettView brettView = 
                spielbrettViewFabrik.erzeugeSpielbrettView(richter);
        Spieler spielerA = spielerFabrikA.erzeugeSpieler(true, parameterA);
        Spieler spielerB = spielerFabrikB.erzeugeSpieler(false, parameterB);
        return new DefaultSpiel(spielerA, spielerB, richter, brettView, 
                                inputDialog, messageDialog);
    }
}

