package framework;

import java.util.List;
import java.util.ArrayList;

public class DefaultSpiel implements Spiel {

    private Spieler spielerA;
    private Spieler spielerB;
    private Schiedsrichter richter;
    private SpielbrettView view;
    private InputDialog inputDialog;
    private MessageDialog messageDialog;
    private List<Spielzug> zuege;
    private List<Spielbrett> bretter;

    public DefaultSpiel(Spieler spielerA, Spieler spielerB, 
                        Schiedsrichter richter, SpielbrettView view,
		        InputDialog inputDialog, 
                        MessageDialog messageDialog) {

        this.zuege = new ArrayList<Spielzug>();
        this.bretter = new ArrayList<Spielbrett>();
	this.spielerA = spielerA;
        this.spielerA.setSpiel(this);
        this.spielerB = spielerB;
        this.spielerB.setSpiel(this);
        this.richter = richter;
        this.richter.setSpiel(this);
	this.inputDialog = inputDialog;
	this.messageDialog = messageDialog;

	this.view = view;     
        this.richter.getBrett().meldeAn(view);
        this.richter.getBrett().initialisiere();
    }

    public List<Spielzug> getZugHistory() {
        return this.zuege;
    }
    
    public List<Spielbrett> getBrettHistory() {
        return this.bretter;
    }

    public Spieler getSpielerA() {
        return this.spielerA;
    }

    public Spieler getSpielerB() {
        return this.spielerB;
    }

    public Schiedsrichter getRichter() {
	return this.richter;
    }
    
    public InputDialog getInputDialog() {
	return this.inputDialog;
    }
    
    public MessageDialog getMessageDialog() {
	return this.messageDialog;
    }

    public void steuereAblauf() {
        Spieler aktuellerSpieler = null;
        Figur figur;
        Spielzug zug;
        boolean zugKorrekt;   
        do {
            aktuellerSpieler = 
                    this.richter.ermittleSpieler(aktuellerSpieler);
            zug = aktuellerSpieler.getZug();
            this.zuege.add(zug);
            this.bretter.add(richter.getBrett());
            if (!this.richter.zugKorrekt(zug, aktuellerSpieler)) {
		break;
            }
            this.richter.fuehreZugAus(zug, aktuellerSpieler);
        } while (!(this.richter.spielBeendet()));
        this.richter.verkuendeSieger();
    }
}


