package framework;

import java.util.List;
import java.util.ArrayList;

public class BasisKoordinatenFigur implements Figur {

    protected Spieler spieler;
    protected KoordinatenSpielfeld feld;

    public BasisKoordinatenFigur (Spieler spieler, 
                                  KoordinatenSpielfeld feld) {
        this.spieler = spieler;
        this.feld = feld;
        //Figur[] figuren = this.spieler.getFiguren();
        //Figur[] figurenNeu = new Figur[figuren.length + 1];
        //for (int i = 0; i < figuren.length; i++) {
        //    figurenNeu[i] = figuren[i];
        //}
        //figurenNeu[figuren.length] = this;
        //this.spieler.setFiguren(figurenNeu);
    }

    public void setFeld(Spielfeld feld) {
        this.feld = (KoordinatenSpielfeld) feld;
    }

    public KoordinatenSpielfeld getFeld() {
        return this.feld;
    }

    public void setSpieler(Spieler spieler) {
        this.spieler = spieler;
    }

    public Spieler getSpieler() {
        return spieler;
    }

    public boolean istA() {
        return this.spieler.istSpielerA();
    }

    protected int getX() {
        return this.feld.getReihe();
    }

    protected int getY() {
        return this.feld.getSpalte();
    }

    protected Spielzug pruefeFeld(int reihe, int spalte) {
        KoordinatenSpielbrett brett = 
                (KoordinatenSpielbrett) this.feld.getBrett();
        Spielfeld ziel = brett.sucheFeld(reihe, spalte);
        if (ziel == null) {
            return null;
        }
        BasisKoordinatenFigur figur = 
                (BasisKoordinatenFigur) ziel.getFigur();
        if (figur == null || (figur != null 
                              && figur.istA() != this.istA())) {
            return new ZweierSpielzug(this.feld, ziel);
        }
        return null;
    }

    protected boolean feldFeindFigur(int reihe, int spalte) {
        KoordinatenSpielbrett brett = 
                (KoordinatenSpielbrett) this.feld.getBrett();
        Spielfeld ziel = brett.sucheFeld(reihe, spalte);
        if (ziel == null) {
            return false;
        }
        BasisKoordinatenFigur figur = 
                (BasisKoordinatenFigur) ziel.getFigur();
        if (figur != null && figur.istA() != this.istA()) {
            return true;
        }
        return false;
    }

    protected boolean feldFrei(int reihe, int spalte) {
        KoordinatenSpielbrett brett = 
                (KoordinatenSpielbrett) this.feld.getBrett();
        Spielfeld ziel = brett.sucheFeld(reihe, spalte);
        if (ziel == null) {
            return false;
        }
        if (ziel.getFigur() == null) {
            return true;
        }
        return false;
    }

    public List<Spielzug> eineRichtung(int x, int y) {
        List<Spielzug> list = new ArrayList<Spielzug>();
        while (feldFrei(getX() + x, getY() + y)) {
            Spielzug zug = pruefeFeld(getX() + x, getY() + y);
            if (zug != null) {
                list.add(zug);
            }
            if (x > 0) {
                x++;
            }
            if (x < 0) {
                x--;
            }
            if (y > 0) {
                y++;
            }
            if (y < 0) {
                y--;
            }
        }
        Spielzug zug = pruefeFeld(getX() + x, getY() + y);
        if (zug != null) list.add(zug);
        return list;
    }
}

