package framework;

abstract public class AbstrakterSpieler implements Spieler{

    protected boolean istSpielerA;
    protected Spiel spiel;
    protected Figur[] figuren;

    public AbstrakterSpieler(boolean istSpielerA) {
        this.istSpielerA = istSpielerA;
        this.figuren = null;
    }

    public Figur[] getFiguren() {
	return this.figuren;
    }

    public void setFiguren(Figur[] figuren) {
	this.figuren = figuren;
    }

    public Spiel getSpiel() {
        return this.spiel;
    }
  
    public void setSpiel(Spiel spiel) {
        this.spiel = spiel;
    }

    public boolean istSpielerA() {
        return this.istSpielerA;
    }

    public String toString() {
        return this.istSpielerA ? "Spieler A" : "Spieler B";
    }
    
    public boolean equals(Object obj) {
	if (obj == null) {
	    return false;
	}
	if (!(obj instanceof Spieler)) {
	    return false;
	}
	Spieler andererSpieler = (Spieler) obj;
	if (this.istSpielerA == andererSpieler.istSpielerA()) {
	    return true;
	}
	return false;	    
    }
}

