package framework;

abstract public class AbstrakterSchiedsrichter implements Schiedsrichter {

    protected Spiel spiel;
    protected Interpreter interpreter;
    protected Spielbrett brett;
    
    public AbstrakterSchiedsrichter () {
        this.interpreter = 
            new AufgabeDekorierer (new SpielzugInterpreter(this));
    }

    public Spielbrett getBrett() {
        return this.brett;
    }
    
    public void setBrett(Spielbrett brett) {
        this.brett = brett;
    }

    public Spiel getSpiel() {
        return spiel;
    }

    public void setSpiel (Spiel spiel) {
        this.spiel = spiel;
    }

    public Interpreter getInterpreter() {
        return interpreter;
    }

    public Spieler ermittleSpieler(Spieler vorherigerSpieler) {
	Spieler spielerA = this.spiel.getSpielerA();
	Spieler spielerB = this.spiel.getSpielerB();
	if (vorherigerSpieler == null 
            || vorherigerSpieler.equals(spielerB)) {
	    return spielerA;
	} else {
	    return spielerB;
	}
    }

    public boolean zugKorrekt(Spielzug zug, Spieler spieler) {
        MessageDialog message = this.spiel.getMessageDialog();
        if (zug == null) {
            message.gebeAus("Es wurde kein gltiger Zug eingegeben.");
            return false;
        }
        Spielzug[] zuege = getAlleZuege(spieler);
        for (Spielzug z : zuege) {      
            if (zug.equals(z)) {
                return true;
            }
        }
        if (!(spieler instanceof MenschSpieler)) {
            throw new FehlerZugException();
        }
        message.gebeAus("Der eingegebene Zug entspricht " 
                                   + "nicht den Spielregeln.");
        return false;  
    }
}

