package dame;

import java.util.List;
import java.util.ArrayList;

import framework.Spieler;
import framework.KoordinatenSpielbrett;
import framework.Spielzug;
import framework.Spielfeld;
import framework.ZweierSpielzug;
import framework.Figur;

public class DameStein extends DameFigur{

    public DameStein(Spieler spieler, Spielfeld feld) {
        super (spieler, feld);
    }
  
    public DameFigur kopiere() {
        return new DameStein (this.spieler, this.feld);
    }

    public String toString() {
        return "Damestein";
    }

    public List<Spielzug> moeglicheSpielzuege() {
        DameSpielbrett brett = (DameSpielbrett) this.feld.getBrett();
        List<Spielzug> list = new ArrayList<Spielzug>();
        Spielfeld[] felder = brett.getFelder();
        int reihe = istA() ? -1 : 1;
        if (feldFrei(getX() + reihe, getY() + 1)) {
            list.add(new ZweierSpielzug(this.feld, 
                                        brett.sucheFeld(getX() + reihe, 
                                        getY() + 1)));
        }
        if (feldFrei(getX() + reihe, getY() - 1)) {
            list.add(new ZweierSpielzug(this.feld, 
                                        brett.sucheFeld(getX() + reihe,
                                        getY() - 1)));
        }
        return list;
    }

    protected Spielzug[] moeglicheSpruenge () {
        DameSpielbrett brett = (DameSpielbrett) this.feld.getBrett();
        List<Spielzug> list = new ArrayList<Spielzug>();
        int reihe = istA() ? -1 : 1;
        Spielzug sprungRechts = moeglicherSprung(reihe, 1);
        if (sprungRechts != null) {
            list.add(sprungRechts);
        }
        Spielzug sprungLinks = moeglicherSprung (reihe, -1);
        if (sprungLinks != null) {
            list.add(sprungLinks);
        }
        return list.toArray(new Spielzug[list.size()]);
    }
}
