package dame;

import java.util.List;
import java.util.ArrayList;

import framework.Spielbrett;
import framework.KoordinatenSpielbrett;
import framework.Spieler;
import framework.Spielfeld;
import framework.Figur;
import framework.Schiedsrichter;
import framework.KoordinatenSpielfeld;

public class DameSpielbrett extends KoordinatenSpielbrett {

    public static final int[][] FIGUR_POSITIONEN_SPIELER_A 
            = { {7, 0}, {7, 2}, {7, 4}, {7, 6},
                {6, 1}, {6, 3}, {6, 5}, {6, 7},
                {5, 0}, {5, 2}, {5, 4}, {5, 6} };

    public static final int[][] FIGUR_POSITIONEN_SPIELER_B 
            = { {0, 1}, {0, 3}, {0, 5}, {0, 7},
                {1, 0}, {1, 2}, {1, 4}, {1, 6},
                {2, 1}, {2, 3}, {2, 5}, {2, 7} };

    public DameSpielbrett(DameSchiedsrichter richter) {
        super(richter, 8, 8);
    }

    public void initialisiere() {
        Spieler spielerA = this.richter.getSpiel().getSpielerA();
        Spieler spielerB = this.richter.getSpiel().getSpielerB();
        for (int[] koordinaten : FIGUR_POSITIONEN_SPIELER_A) {
            int reihe = koordinaten[0];
            int spalte = koordinaten[1];
            Spielfeld feld = sucheFeld(reihe, spalte); 
            weiseZu(feld, new DameStein (spielerA, feld));
        }
        for (int[] koordinaten : FIGUR_POSITIONEN_SPIELER_B) {
            int reihe = koordinaten[0];
            int spalte = koordinaten[1];
            Spielfeld feld = sucheFeld(reihe, spalte); 
            weiseZu(feld, new DameStein (spielerB, feld));
        }
        for (Spielfeld feld : felder) {
            if (feld.getFigur() != null) {
                feld.getFigur().setFeld(feld);
            }
        }    
        benachrichtige();
    }

    public Spielbrett kopiere(Schiedsrichter richter) {
        Spielbrett kopie = new DameSpielbrett((DameSchiedsrichter) richter);
        kopie.setFelder(new KoordinatenSpielfeld[64]);
        Spielfeld[] kopieFelder = kopie.getFelder();
        int counter = 0;
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                kopieFelder[counter] = 
                    new KoordinatenSpielfeld(kopie, i, j);
                counter++;
            }
        }
        for (int i = 0; i < this.felder.length; i++) {
            Spielfeld kopieFeld = kopieFelder[i];
            Figur figur = this.felder[i].getFigur();
            if (figur != null) {
                Figur k = ((DameFigur)figur).kopiere();
                kopieFeld.setFigur(k);
                k.setFeld (kopieFeld);
            }
        }
        return kopie;
    }
}
