package dame;

import java.util.ArrayList;
import java.util.List;
import java.util.LinkedList;
import java.util.StringTokenizer;

import framework.Schiedsrichter;
import framework.AbstrakterSchiedsrichter;
import framework.Spieler;
import framework.Spielbrett;
import framework.Spielfeld;
import framework.Spielzug;
import framework.ZweierSpielzug;
import framework.PolySpielzug;
import framework.Figur;
import framework.BasisKonstanten;
import framework.DefaultSpielbrett;
import framework.MessageDialog;
import framework.KoordinatenSpielfeld;
import framework.Spiel;

public class DameSchiedsrichter extends AbstrakterSchiedsrichter 
                                implements BasisKonstanten {

    private DameSpielbrett brett;
    private Spieler sieger;

    public DameSchiedsrichter() {
        super();
        this.brett = new DameSpielbrett(this);
    }

    public DameSchiedsrichter(Spielbrett brett) {
        super();
        this.brett = (DameSpielbrett) brett;
    }

    public Schiedsrichter kopiere() {
        DameSchiedsrichter kopie = new DameSchiedsrichter(this.brett);
        kopie.setSpiel(this.getSpiel());
        kopie.setBrett((DameSpielbrett) brett.kopiere(kopie));
        return kopie;
    }

    public String toString() {
        return "Dame";
    }

    public Spielzug[] alleSprungzuege(Spieler spieler) {
        List<Spielzug> list = new ArrayList<Spielzug>();
        Spielfeld[] felder = this.brett.getFelder();
        for (Spielfeld feld : felder) {
            DameFigur f = (DameFigur) feld.getFigur();
            if (f == null) {
                continue;
            }
            if (!(f.getSpieler().equals(spieler))) {
                continue;
            }
            list.addAll(f.moeglicheSprungZuege(new PolySpielzug (feld), 
                                               new LinkedList<Spielzug>())
                       );
        }
        if (list != null && list.size() > 0) {
            return list.toArray(new Spielzug[list.size()]);
        } else {
            return null;
        }
    }

    public Spielzug[] getAlleZuege(Spieler spieler) {       
        Spielzug[] sprungzuege = alleSprungzuege(spieler);
        if (sprungzuege != null && sprungzuege.length > 0) {
            return sprungzuege;
        }
        List<Spielzug> list = new ArrayList<Spielzug>();
        Spielfeld[] felder = this.spiel.getRichter().getBrett().getFelder();
        this.brett = (DameSpielbrett) this.spiel.getRichter().getBrett();
        for (Spielfeld feld : felder) {
            Figur f = feld.getFigur();
            if (f == null) {
                continue;
            }
            if (!(f.getSpieler().equals(spieler))) {
                continue;
            }
            list.addAll(((DameFigur)f).moeglicheSpielzuege());
        }
        return list.toArray(new Spielzug[list.size()]);
    }

    public void fuehreZugAus(Spielzug zug, Spieler spieler) {
        if (zug.getFelder().length == 2) {
            fuehreZweierZugAus(zug, spieler);
        } else {
            for (int i = 0; i < (zug.getFelder().length - 1); i++) {
                fuehreZweierZugAus(new ZweierSpielzug(zug.getFelder()[i], 
                                                      zug.getFelder()[i+1]), 
                                                      spieler);
            }
        }
    }

    public void fuehreZweierZugAus(Spielzug zug, Spieler spieler) {
        KoordinatenSpielfeld sk = (KoordinatenSpielfeld) zug.getStart();
        KoordinatenSpielfeld zk = (KoordinatenSpielfeld) zug.getZiel();
        DameFigur f = (DameFigur) sk.getFigur();
        this.brett = (DameSpielbrett) this.spiel.getRichter().getBrett();
        this.brett.weiseZu(zk, f);
        for (int i = 0; i < DIAGONAL_1.length; i++) {
            if ((sk.getReihe() + DIAGONAL_2[i][0] == zk.getReihe()) 
                 && (sk.getSpalte() + DIAGONAL_2[i][1] == zk.getSpalte())) {
                Spielfeld loeschfeld = 
                    brett.sucheFeld((sk.getReihe() + DIAGONAL_1[i][0]), 
                                    (sk.getSpalte() + DIAGONAL_1[i][1]));
                if (loeschfeld.getFigur() != null) {
                    this.brett.weiseZu(loeschfeld, null);
                    break;
                }
            }
        }
        if (zug.getZiel().getFigur() != null) {
            if (zug.getZiel().getFigur() instanceof DameStein) {
                if (spieler.istSpielerA() 
                  && ((KoordinatenSpielfeld)zug.getZiel()).getReihe() == 0) {
                    this.brett.wandleUm(zug.getZiel().getFigur(), 
                                    new DameDame (this.spiel.getSpielerA(),
                                                  zug.getZiel()));
                } else if (!(spieler.istSpielerA()) 
                         && ((KoordinatenSpielfeld)zug.getZiel()).getReihe() 
                               == 7) {
                    this.brett.wandleUm(zug.getZiel().getFigur(), 
                                       new DameDame(this.spiel.getSpielerB(),
                                                    zug.getZiel())
                                        );
                }
            }
        }
    }

    public boolean spielBeendet() {
        Spielfeld[] felder = this.spiel.getRichter().getBrett().getFelder();
        boolean spielerA = false;
        boolean spielerB = false;
        for (Spielfeld feld : felder) {
            Figur figur = feld.getFigur();
            if (figur != null) {
                if (figur.getSpieler().istSpielerA()) {
                    spielerA = true;
                    this.sieger = this.spiel.getSpielerA();
                } else {
                    spielerB = true;
                    this.sieger = this.spiel.getSpielerA();
                }
            }
            if (spielerA & spielerB) {
                return false;
            }
        }
        return true;
    }

    public void verkuendeSieger () {
        MessageDialog message = this.spiel.getMessageDialog();
        if (sieger == null) {
            message.gebeAus("Spielabbruch. Es steht unentschieden.");
        } else {
            if (this.sieger.istSpielerA()) {
                message.gebeAus("Spieler A ist Sieger!");
            } else {
                message.gebeAus("Spieler B ist Sieger!");
            }
        }
    }

    private boolean istSprungZug(Spielzug zug, Spielzug[] sprungzuege) {
        if (zug == null) {
            return false;
        }
        if (sprungzuege == null) {
            return false;
        }
        for (int i = 0; i < sprungzuege.length; i++) {
            if (zug.equals(sprungzuege[i])) {
                return true;
            }
        }
        return false;
    }
}
