package dame;

import java.util.List;
import java.util.ArrayList;

import framework.BasisKoordinatenFigur;
import framework.Spieler;
import framework.Spielzug;
import framework.ZweierSpielzug;
import framework.PolySpielzug;
import framework.Spielbrett;
import framework.Figur;
import framework.Schiedsrichter;
import framework.KoordinatenSpielbrett;
import framework.KoordinatenSpielfeld;
import framework.Spielfeld;

abstract public class DameFigur extends BasisKoordinatenFigur {

    public DameFigur(Spieler spieler, Spielfeld feld) {
        super(spieler, (KoordinatenSpielfeld) feld);
    }

    public List<Spielzug> moeglicheSprungZuege(PolySpielzug zug, 
                                               List<Spielzug> list) {
        Spielzug[] aktuelleZuege = moeglicheSpruenge();
        if (aktuelleZuege != null && aktuelleZuege.length > 0) {
            for (Spielzug z : aktuelleZuege) {
                Schiedsrichter kopie = 
                    this.feld.getBrett().getRichter().kopiere();
                KoordinatenSpielfeld[] felder = 
                    (KoordinatenSpielfeld[]) kopie.getBrett().getFelder();
                zug.erweitere(z.getZiel());
                z = new ZweierSpielzug(
                      transformiere(
                        z.getStart(), this.feld.getBrett(), kopie.getBrett()
                      ),
                      transformiere(
                        z.getZiel(),this.feld.getBrett(),kopie.getBrett()
                      )
                );
                kopie.fuehreZugAus(z, getSpieler());
                DameFigur kopieFigur = null;
                KoordinatenSpielfeld f = (KoordinatenSpielfeld) z.getZiel();
                kopieFigur = (DameFigur) f.getFigur();
                if (kopieFigur != null) {
                    list = kopieFigur.moeglicheSprungZuege (zug, list);
                }
            }
        } else {
            if (zug.getFelder().length > 1) {
                list.add (zug);
            }
        }
        return list;
    }

    protected Spielzug moeglicherSprung(int reihe, int spalte) {
        DameSpielbrett brett = (DameSpielbrett) this.feld.getBrett();
        int reihe2 = (reihe > 0) ? 2 : -2;
        int spalte2 = (spalte > 0) ? 2 : -2;
        if (feldFeindFigur(getX() + reihe, getY() + spalte)) {
            if (feldFrei(getX() + reihe2, getY() + spalte2)) {
                KoordinatenSpielbrett xybrett = 
                    (KoordinatenSpielbrett) brett;
                return new ZweierSpielzug (this.feld, 
                                           xybrett.sucheFeld (getX() 
                                             + reihe2, 
                                           getY() + spalte2));
            }
        }
        return null;
    }
    
    abstract protected Spielzug[] moeglicheSpruenge();
   
    abstract public List<Spielzug> moeglicheSpielzuege();
    
    abstract public DameFigur kopiere();
  
    private KoordinatenSpielfeld transformiere(Spielfeld feld, 
                                               Spielbrett brett, 
                                               Spielbrett kopie) {
        KoordinatenSpielfeld[] felder = 
            (KoordinatenSpielfeld[]) kopie.getFelder();
        for (KoordinatenSpielfeld f : felder) {
            if (f.getReihe() == ((KoordinatenSpielfeld)feld).getReihe() 
              && f.getSpalte() == ((KoordinatenSpielfeld)feld).getSpalte()) {
                return f;
            }
        }
        return null;
    }
}
