package dame;

import java.util.List;
import java.util.ArrayList;

import framework.Spieler;
import framework.Spielbrett;
import framework.Spielzug;
import framework.Spielfeld;
import framework.ZweierSpielzug;
import framework.BasisKonstanten;
import framework.Figur;

public class DameDame extends DameFigur implements BasisKonstanten {

    public DameDame(Spieler spieler, Spielfeld feld) {
        super(spieler, feld);
    }

    public DameFigur kopiere() {
        return new DameDame(this.spieler, this.feld);
    }

    public String toString() {
        return "DameDame";
    }

    public List<Spielzug> moeglicheSpielzuege() {
        DameSpielbrett brett = (DameSpielbrett) this.feld.getBrett();
        List<Spielzug> list = new ArrayList<Spielzug>();
        Spielfeld[] felder = brett.getFelder();
        for (int[] d : DIAGONAL_1) {
            if (feldFrei (getX() + d[0], getY() + d[1])) {
                list.add (new ZweierSpielzug(this.feld, 
                                             brett.sucheFeld(getX() + d[0], 
                                             getY() + d[1])));
            }
        }
        return list;
    }

    protected Spielzug[] moeglicheSpruenge () {
        DameSpielbrett brett = (DameSpielbrett) this.feld.getBrett();
        List<Spielzug> list = new ArrayList<Spielzug>();
        for (int[] d : DIAGONAL_1) {
            Spielzug sprung = moeglicherSprung(d[0], d[1]);
            if (sprung != null) {
                list.add(sprung);
            }
        }
        return list.toArray(new Spielzug[list.size()]);
    }
}
