package dame;

import java.util.ArrayList;
import framework.Spielbrett;
import framework.Spielfeld;
import framework.Schiedsrichter;
import framework.Figur;
import framework.DefaultBewertung;

public class DameBewertung extends DefaultBewertung {

    public static final String[] moeglicheSpiele = { "Dame" };

    public DameBewertung (Schiedsrichter richter) {
        boolean bewertbar = false;
        for (String str : moeglicheSpiele) {
            if (richter.toString().equals(str)) {
                bewertbar = true;
            }
        }
        if (!bewertbar) {
            throw new IllegalArgumentException();
        }
    }

    public int analysiere(Spielbrett brett) {
        int ergebnis = 0;
        ergebnis = super.analysiere(brett);
        Spielfeld[] felder = brett.getFelder();
        //Anzahl der Damen
        for (Spielfeld feld : felder) {
            Figur figur = feld.getFigur();
            if (figur != null && figur instanceof DameDame) {
                if (figur.getSpieler().istSpielerA()) {
                    ergebnis++;
                } else {
                    ergebnis--;
                }
            }
        }
        return ergebnis;
    }        
}
