package entwurfsmuster.vermittler;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class VaterHamster extends Hamster implements DirektorHamster {
 
    public final static int[][] labyrinth = { { 4, 6, WEST}, { 0, 4, WEST}, 
                                              { 8, 3, OST }, { 8, 6, SUED}, 
                                              {10, 6, WEST}, {10, 4, WEST},
                                              {16, 8, OST }                 };

    private FaulerSohnHamster faulerSohn;
    private FleissigerSohnHamster fleissigerSohn;
    private DienerHamster diener;

    public VaterHamster(int r, int s, int b, int k) {
        super(r, s, b, k);
    }

    public void erzeugeElementHamster() {
        this.faulerSohn = new FaulerSohnHamster (this);
        this.fleissigerSohn = new FleissigerSohnHamster (this);
        this.diener = new DienerHamster (this);    
    }
  
    public void behandleEreignis (ElementHamster element) {
        if (element.equals(fleissigerSohn)) {
            for (int[] koordinaten : labyrinth) {
                if (koordinaten[0] == element.getReihe() 
                        && koordinaten[1] == element.getSpalte()) {
                    element.setzeBlickrichtung (koordinaten[3]);
                    switch (koordinaten[3]) {
                    case NORD:
                        schreib("Vater: Du musst nach Norden gehen.");
                        break;
                    case OST:
                        schreib("Vater: Du musst nach Osten gehen.");
                        break;
                    case SUED:
                        schreib("Vater: Du musst nach Sueden gehen.");
                        break;
                    case WEST:
                        schreib("Vater: Du musst nach Westen gehen.");
                        break;
                    }
                    break;
                }
            }
        } else if (element.equals(faulerSohn)) {
            int zufallszahl = (int) (Math.random() * 2);
            if (zufallszahl == 0) {
                schreib("Vater: Du darfst das Korn fressen.");
                faulerSohn.nimm();
            } else {
                schreib("Vater: Du darfst das Korn nicht fressen.");
            }
        } else if (element.equals(diener)) {
          schreib("Das sind zu wenig. Pflanze Koerner nach.");
          diener.pflanzeKoernerAn();
        }
    }
  
    public void steuereAblauf() {
        int zaehler = 0;
        while(fleissigerSohn.getReihe() !=  16 
                  || fleissigerSohn.getSpalte() != 10) {
            fleissigerSohn.erforscheLabyrinth();
            faulerSohn.spaziere();
            if (zaehler % 5 == 0) {
                diener.zaehleKoernerAufFeld();
            }
            zaehler++;
        }
        schreib("Vater: Fauler Sohn, Du hast genug gefressen, " 
                    + "jetzt ist Dein fleissiger Bruder dran.");
        fleissigerSohn.fresseKoerner();
    } 	
}
