package entwurfsmuster.vermittler;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class DienerHamster extends ElementHamster {

    public DienerHamster (DirektorHamster direktor) {
        super (13, 18, WEST, 100, direktor);
    }

    public void zaehleKoernerAufFeld() {
        int anzahl = 0;
        for (int i = 13; i <= 18; i++) {
            for (int j = 13; j <= 17; j++) {
                anzahl += Territorium.getAnzahlKoerner (i, j); 
            }
        }
        if (anzahl < 30) {
            schreib ("Auf dem Feld liegen weniger als 30 Koerner.");
            behandleEreignis();
        }  
    }

    public void pflanzeKoernerAn() {
        int schritte = 5;
        for (int i = 0; i < 10; i++) {
            for (int j = 0; j < schritte; j++) {
                int zufall = (int) (Math.random() * 2);
                vor();
                if (zufall == 0) {
                    gib();
                }
            }
            linksUm();
            if (i % 2 != 0) {
                schritte--;
            }
        }
        gotoKachel(13,18);
        setzeBlickrichtung(WEST);
    }   	
}
