package entwurfsmuster.strategie.strategieC;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class VerbesserteStrategie implements Strategie {

    private List<int[]> pos;

    public VerbesserteStrategie() {
        this.pos = new ArrayList<int[]>();
    }

    public void sammle(SammelHamster hamster) {
        int[] aktuellePosition = { hamster.getReihe(), hamster.getSpalte() };
        pos.add(aktuellePosition);
        List<int[]> moeglich = new ArrayList<int[]>();
        int[] richtungN = { hamster.getReihe() - 1, hamster.getSpalte() };
        int[] richtungO = { hamster.getReihe(), hamster.getSpalte() + 1 };
        int[] richtungS = { hamster.getReihe() + 1, hamster.getSpalte() };
        int[] richtungW = { hamster.getReihe(), hamster.getSpalte() - 1 };
        boolean nord = true;
        boolean ost = true;
        boolean sued = true;
        boolean west = true;  
        for (int[] position : pos) {
            if (Arrays.equals(position, richtungN)) {
                nord = false;
            }
            if (Arrays.equals(position, richtungO)) {
                ost = false;
            }
            if (Arrays.equals(position, richtungS)) {
                sued = false;
            }
            if (Arrays.equals(position, richtungW)) {
                west = false;
            }
        }
        if (nord) {
            moeglich.add(richtungN);
        }
        if (ost) {
            moeglich.add(richtungO);
        }
        if (sued) {
            moeglich.add(richtungS);
        }
        if (west) {
            moeglich.add(richtungW);
        }
        if (moeglich.size() < 1) {
            moeglich.add(richtungN);
            moeglich.add(richtungO);
            moeglich.add(richtungS);
            moeglich.add(richtungW);
        }
        int zufall = (int) (Math.random() * moeglich.size());
        int[] gewaehlteRichtung = moeglich.get (zufall);
        if (Territorium.mauerDa(gewaehlteRichtung[0], 
                                gewaehlteRichtung[1])) {
            pos.add(gewaehlteRichtung);
        }
        if (Arrays.equals(gewaehlteRichtung, richtungN)) {
            hamster.setzeBlickrichtung(Hamster.NORD);
            hamster.vorUndNimm();
        }
        if (Arrays.equals(gewaehlteRichtung, richtungO)) {
            hamster.setzeBlickrichtung(Hamster.OST);
            hamster.vorUndNimm();
        }
        if (Arrays.equals(gewaehlteRichtung, richtungS)) {
            hamster.setzeBlickrichtung(Hamster.SUED);
            hamster.vorUndNimm();
        }
        if (Arrays.equals(gewaehlteRichtung, richtungW)) {
            hamster.setzeBlickrichtung(Hamster.WEST);
            hamster.vorUndNimm();
        }
    }

    public String gebeAus(Hamster hamster) {
        return "Hamster mit verbesserter Strategie hat " 
                 + hamster.getAnzahlKoerner()
                 + " Krner im Maul.";
    }
}