package entwurfsmuster.strategie.strategieC;

import java.util.List;
import java.util.ArrayList;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class SuperStrategie implements Strategie {

    private int zielReihe;
    private int zielSpalte;

    public SuperStrategie() {
        this.zielReihe = -1;
        this.zielSpalte = -1;
    }

    public void sammle(SammelHamster hamster) {
        if (hamster.getReihe() == this.zielReihe 
               && hamster.getSpalte() == this.zielSpalte) {
            if (hamster.kornDa()) {
                hamster.nimm();
            }
            this.zielReihe = -1;
            this.zielSpalte = -1;
        } else if (this.zielReihe == -1 && this.zielSpalte == -1) {
            sucheKorn(hamster);
        }
        if (this.zielReihe != hamster.getReihe()) {
            if (this.zielReihe > hamster.getReihe()) {
                hamster.setzeBlickrichtung(Hamster.SUED);
            } else {
                hamster.setzeBlickrichtung(Hamster.NORD);
            }
        } else {
            if (this.zielSpalte > hamster.getSpalte()) {
                hamster.setzeBlickrichtung(Hamster.OST);
            } else {
                hamster.setzeBlickrichtung(Hamster.WEST);
            }
        }
        if (hamster.vornFrei()) {
            hamster.vor();
        }    
    }

    private int berechneWeg(Hamster hamster, int reihe, int spalte) {
        int r = Math.abs(hamster.getReihe() - reihe);
        int s = Math.abs(hamster.getSpalte() - spalte);
        return r + s;
    }

    private void sucheKorn (Hamster hamster) {
        int schritte = 1;
        int abstand = 0;
        int blick = hamster.getBlickrichtung();
        for (int i = 0; i < 100; i++) {
            for (int j = 0; j < schritte; j++) {
                int reiheAktuell = hamster.getReihe(); 
                int spalteAktuell = hamster.getSpalte();
                switch (blick) {
                case Hamster.OST:
                    reiheAktuell += abstand;
                    spalteAktuell +=j;
                    break;
                case Hamster.NORD:
                    reiheAktuell -= j;
                    spalteAktuell += abstand;
                    break;
                case Hamster.WEST:
                    reiheAktuell -= abstand;
                    spalteAktuell -= j;
                    break;
                case Hamster.SUED:
                    reiheAktuell += j;
                    spalteAktuell -= abstand;
                }
                if (Territorium.getAnzahlKoerner(reiheAktuell, 
                                                 spalteAktuell) > 0) {
                    this.zielReihe = reiheAktuell;
                    this.zielSpalte = spalteAktuell;
                    return;
                }
            }
            blick = ((blick + 3) % 4);
            if (i % 2 == 0) {
                schritte++;
            }
            if (i % 4 == 0) {
                abstand++;
            }
        }
    }

    public String gebeAus(Hamster hamster) {
        return "Hamster mit Super-Strategie hat " 
                 + hamster.getAnzahlKoerner()
                 + " Krner im Maul.";
    }
}