package entwurfsmuster.strategie.strategieA;

import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import entwurfsmuster.AllroundHamster;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class VerbesserterSammelHamster extends AllroundHamster {

  private List<int[]> pos;

    public VerbesserterSammelHamster(int r, int s, int b, int k) {
        super(r, s, b, k);
        this.pos = new ArrayList<int[]>();
    }

    public void sammle() {
        int[] aktuellePosition = {getReihe(), getSpalte()};
        pos.add(aktuellePosition);
        List<int[]> moeglich = new ArrayList<int[]>();
        int[] richtungN = {getReihe() - 1, getSpalte()};
        int[] richtungO = {getReihe(), getSpalte() + 1};
        int[] richtungS = {getReihe() + 1, getSpalte()};
        int[] richtungW = {getReihe(), getSpalte() - 1};
        boolean nord = true;
        boolean ost = true;
        boolean sued = true;
        boolean west = true;  
        for (int[] position : pos) {
            if (Arrays.equals(position, richtungN)) {
                nord = false;
            }
            if (Arrays.equals(position, richtungO)) {
                ost = false;
            }
            if (Arrays.equals(position, richtungS)) {
                sued = false;
            }
            if (Arrays.equals(position, richtungW)) {
                west = false;
            }
        }
        if (nord) {
            moeglich.add(richtungN);
        }
        if (ost) {
            moeglich.add(richtungO);
        }
        if (sued) {
            moeglich.add(richtungS);
        }
        if (west) {
            moeglich.add(richtungW);
        }
        if (moeglich.size() < 1) {
            moeglich.add(richtungN);
            moeglich.add(richtungO);
            moeglich.add(richtungS);
            moeglich.add(richtungW);
        }
        int zufall = (int) (Math.random() * moeglich.size());
        int[] gewaehlteRichtung = moeglich.get (zufall);
        if (Territorium.mauerDa(gewaehlteRichtung[0], 
                                gewaehlteRichtung[1])) {
            pos.add (gewaehlteRichtung);
        }
        if (Arrays.equals(gewaehlteRichtung, richtungN)) {
            setzeBlickrichtung(Hamster.NORD);
            vorUndNimm();
        }
        if (Arrays.equals(gewaehlteRichtung, richtungO)) {
            setzeBlickrichtung(Hamster.OST);
            vorUndNimm();
        }
        if (Arrays.equals(gewaehlteRichtung, richtungS)) {
            setzeBlickrichtung(Hamster.SUED);
            vorUndNimm();
        }
        if (Arrays.equals(gewaehlteRichtung, richtungW)) {
            setzeBlickrichtung(Hamster.WEST);
            vorUndNimm();
        }
    }

    public String toString() {
        return "VerbesserterSammelHamster hat " + getAnzahlKoerner()
                 + " Krner im Maul.";
    } 
}