package entwurfsmuster.strategie.strategieA;

import entwurfsmuster.AllroundHamster;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class SuperSammelHamster extends AllroundHamster {

    private int zielReihe;
    private int zielSpalte;

    public SuperSammelHamster(int r, int s, int b, int k) {
        super(r, s, b, k);
        this.zielReihe = -1;
        this.zielSpalte = -1;
    }

    public void sammle() {
        if (getReihe() == this.zielReihe 
                && getSpalte() == this.zielSpalte) {
            if (kornDa()) {
                nimm();
            }
            this.zielReihe = -1;
            this.zielSpalte = -1;
        } else if (this.zielReihe == -1 && this.zielSpalte == -1) {
            sucheKorn();      
        }
        if (this.zielReihe != getReihe()) {
            if (this.zielReihe > getReihe()) {
                setzeBlickrichtung(Hamster.SUED);
            } else {
                setzeBlickrichtung(Hamster.NORD);
            }
        } else {
            if (this.zielSpalte > getSpalte()) {
                setzeBlickrichtung(Hamster.OST);
            } else {
                setzeBlickrichtung(Hamster.WEST);
            }
        }
        if (vornFrei()) {
            vor();
        }    
    }

    private int berechneWeg(int reihe, int spalte) {
        int r = Math.abs(getReihe() - reihe);
        int s = Math.abs(getSpalte() - spalte);
        return r + s;
    }

    private void sucheKorn() {
        int schritte = 1;
        int abstand = 0;
        int blick = getBlickrichtung();
        for (int i = 0; i < 100; i++) {
            for (int j = 0; j < schritte; j++) {
                int reiheAktuell = getReihe(); 
                int spalteAktuell = getSpalte();
                switch (blick) {
                case Hamster.OST:
                    reiheAktuell += abstand;
                    spalteAktuell +=j; 
                    break;
                case Hamster.NORD:
                    reiheAktuell -= j;
                    spalteAktuell += abstand;
                    break;
                case Hamster.WEST: 
                    reiheAktuell -= abstand;
                    spalteAktuell -= j;
                    break;
                case Hamster.SUED:
                    reiheAktuell += j;
                    spalteAktuell -= abstand;
                }
                if (Territorium.getAnzahlKoerner(reiheAktuell, 
                                                 spalteAktuell) > 0) {
                    this.zielReihe = reiheAktuell;
                    this.zielSpalte = spalteAktuell;
                    return;
                }
            }
            blick = ((blick + 3) % 4);
            if (i % 2 == 0) {
                schritte++;
            }
            if (i % 4 == 0) {
                abstand++;
            }
        }
    }

    public String toString() {
        return "SuperSammelHamster hat " + getAnzahlKoerner()
                 + " Krner im Maul.";
    }
}