package entwurfsmuster.singleton.singletonA;

import java.util.List;
import java.util.ArrayList;
import entwurfsmuster.beobachter.beobachterE.ZaehlHamster;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class SchiedsrichterHamster extends Hamster {

    public static final int SPIELER_ANZAHL_MAX = 4;
    private List<ZaehlHamster> laeufer;
    private List<SammelHamster> sammler;

    public SchiedsrichterHamster(int r, int s, int b, int k) {
        super(r, s, b, k);
        this.laeufer = new ArrayList<ZaehlHamster>();
        this.sammler = new ArrayList<SammelHamster>();
    }

    public void meldeZumSpielAn(Hamster hamster) {
        if (hamster instanceof ZaehlHamster 
                && this.laeufer.size() <= SPIELER_ANZAHL_MAX) {
            this.laeufer.add((ZaehlHamster)hamster);
        } else if (hamster instanceof SammelHamster 
                       && this.sammler.size() <= SPIELER_ANZAHL_MAX) {
            this.sammler.add((SammelHamster)hamster);
        } else {
            schreib("Anmeldung nicht mglich.");    
        }
    }

    public void steuereAblauf() {
        boolean gewonnen = false;
        ordneHamsterZu();
        while (!gewonnen) {
            for (int i = 0; i < laeufer.size(); i++) {
                ZaehlHamster zaehlHamster = this.laeufer.get(i);
                SammelHamster sammelHamster = this.sammler.get(i);
                sammelHamster.sammle();
                gewonnen = kontrolliereSpalten(zaehlHamster);
                if (gewonnen) {
                    gebeGewinnerBekannt(zaehlHamster, sammelHamster);
                    return;
                }
            }
        }
    }

    private void ordneHamsterZu() {
        if (this.laeufer.size() == this.sammler.size()) {
            for (int i=0; i < laeufer.size(); i++) {
                sammler.get(i).meldeAn(laeufer.get(i));
            }
        } 
    }

    private boolean kontrolliereSpalten(ZaehlHamster zaehlHamster) { 
        return this.getSpalte() == zaehlHamster.getSpalte();
    }

    private void gebeGewinnerBekannt(ZaehlHamster laeufer, 
                                     SammelHamster sammler) {    
        schreib("Gewonnen haben " + laeufer.toString() + " und " 
                    + sammler.toString() + "!");
    }
}