package entwurfsmuster.schablone;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class AndererKornHolHamster extends KornHolHamster {

    public AndererKornHolHamster(int r, int s, int b, int k) {
        super(r, s, b, k);
    }

    public void laufHin(int reihe, int spalte) {
        if (spalte > getSpalte()) {
            setzeBlickrichtung(Hamster.OST);
        } else {
            setzeBlickrichtung(Hamster.WEST);
        }
        while (spalte != getSpalte()) {
            vor();
        }
        if (reihe > getReihe()) {
            setzeBlickrichtung(Hamster.SUED);
        } else {
            setzeBlickrichtung(Hamster.NORD);
        }
        while (reihe != getReihe()) {
            vor();
        }
    }

    public void freueDich() {
        setzeBlickrichtung(SUED);
        vor();
        kehrt();
        vor();
        setzeBlickrichtung(WEST);
        vor();
        kehrt();
        vor();       
    }

    public void laufZurueck() {
        laufHin(this.startReihe, this.startSpalte);
    }
}
