package entwurfsmuster.interpreter;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class SubTerm implements Term {

    private Term op1;
    private Term op2;

    public SubTerm(Term op1, Term op2) {
        this.op1 = op1;
        this.op2 = op2;
    }

    public int werteAus(Kontext kontext) {
        return this.op1.werteAus(kontext) - this.op2.werteAus(kontext);
    }

    public Term kopiere() {
        return new SubTerm(this.op1.kopiere(), this.op2.kopiere());
    }

    public Term ersetze(String name, Term term) {
        return new SubTerm(this.op1.ersetze(name, term), 
                           this.op2.ersetze(name, term));
    }  	
}
