package entwurfsmuster.interpreter;

import java.util.List;
import java.util.ArrayList;
import java.util.StringTokenizer;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class ParserHamster extends Hamster {

    private List<Variable> variablen;

    public ParserHamster(int r, int s, int b, int k) {
        super(r, s, b, k);
        variablen = new ArrayList<Variable>();
    }

    public List<Variable> getVariablen() {
        return variablen;
    }

    private List<Object> leseTermEin() {
        variablen.clear();
        Kontext kontext = new Kontext(); 
        String s = liesZeichenkette("Bitte Term eingeben.");
        StringTokenizer tokenizer = new StringTokenizer(s);
        List<Object> list = new ArrayList<Object>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    private List<Object> findeVariablen(List<Object> list) {
        for (Object token : list) {
            if (Character.isLetter(((String)token).toString().charAt(0))) {
                boolean gefunden = false;
                for (Variable variable : this.variablen) {         
                    if (variable.getName().equals(token.toString())) {
                        list.set(list.indexOf(token), variable);
                        gefunden = true;
                    }
                }
                if (!gefunden) {
                    Variable var = new Variable(token.toString());
                    list.set(list.indexOf(token), var);
                    variablen.add(var);
                }
            }
        }    
        return list;
    }

    private Term findeTerm(Object obj_1, Object obj_2, Object obj_3) {
        if (obj_1 instanceof Term && obj_3 instanceof Term) {
            if (obj_2.toString().equals("+")) {
                return new AddTerm((Term) obj_1, (Term) obj_3);
            }
            if (obj_2.toString().equals("-")) {
                return new SubTerm((Term) obj_1, (Term) obj_3);
            }
        } 
        return null;
    }

    private boolean klammernDa(Object obj_1, Object obj_2, Object obj_3) {
        if (obj_1.toString().equals("(") && obj_3.toString().equals(")")) {
            if (obj_2 instanceof Term) {
                return true;
            }
        } 
        return false;
    }


    private List<Object> raeumeListeAuf (List<Object> list, int index) {
        for (int j = (index + 1); j < (list.size() - 2); j++) {
            list.set(j, list.get (j + 2));
        }
        list.remove(list.size() - 1);
        list.remove(list.size() - 1);
        return list;
    }

    public Term parseString() {
        List<Object> list = leseTermEin();
        list = findeVariablen(list);
        while (list.size() > 1) {
            //Sub und Add Terme suchen
            for (int i = 0; i < (list.size() - 2); i++) {
                Term t = findeTerm(list.get(i), list.get (i+1), list.get (i+2));
                if (t != null) {
                    list.set(i, t);
                    list = raeumeListeAuf(list, i);
                }
            }    
           //Klammern entfernen
           for (int i = 0; i < (list.size() - 2); i++) {               
               if (klammernDa(list.get(i), list.get(i+1), list.get(i+2))) {
                   list.set(i, list.get(i+1));
                   list = raeumeListeAuf(list, i);
               }
           }    
       }
       return (Term) list.get(0);   
    }
}