package entwurfsmuster;

import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class AllroundHamster extends Hamster {

    public AllroundHamster(int r, int s, int b, int k) {
        super(r, s, b, k);
    }
  
    public void vorUndNimm () {
        if (vornFrei()) {
            vor();
            if (kornDa()) {
                nimm();    
            }
        }
    }

    public void kehrt() {
        linksUm();
        linksUm();
    }
  
    public void rechtsUm() {
        kehrt();
        linksUm();
    }

    public boolean linksFrei() {
        linksUm();
        boolean frei = vornFrei();
        rechtsUm();
        return frei;
    }

    public boolean rechtsFrei() {
        rechtsUm();
        boolean frei = vornFrei();
        linksUm();
        return frei;
    }

    public void setzeBlickrichtung(int richtung) {
        while (getBlickrichtung() != richtung) {
            linksUm();
        }
    }
  
    public void gotoKachel(int reihe, int spalte) {
        if (reihe > getReihe()) {
            setzeBlickrichtung(Hamster.SUED);
        } else {
            setzeBlickrichtung(Hamster.NORD);
        }
        while (reihe != getReihe()) {
            vor();
        }
        if (spalte > getSpalte()) {
            setzeBlickrichtung(Hamster.OST);
        } else {
            setzeBlickrichtung(Hamster.WEST);
        }
        while (spalte != getSpalte()) {
            vor();
        }
    }
}
