//012345678901234567890123456789012345678901234567890123456789012345678901234567890
// Demonstration des ShellSort-Algorithmus
import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class ShellSortHamster 
  extends KoernerHaufenSortierHamster 
  implements SortierHamster 
{

  private MarkierungsHamster aktIndexHamster = null;
    // markiert den Start des unsortierten Teils

  private int anzahlKoernerHaufen = 0;
    // Anzahl der zu sortierenden Koernerhaufen

  private int anzahlDeponierteKoerner = 0;
    // Koerneranzahl des aktuellen Koernerhaufens

  private MarkierungsHamster[] distanzHamster = null;
    // markieren die Elemente des aktuell sortierten Teil-Arrays

  private int anzahlTeilArrayMarkierungsHamster = 0;
    // Anzahl an aktuell aktiven Teil-Array-Markierungshamstern

  // Konstruktor
  public ShellSortHamster(boolean mitErlaeuterungen) {
    super(mitErlaeuterungen);
    this.erlaeuterung(
      "Ich sortiere die Koernerhaufen auf der Basis des ShellSort-Algorithmus.");
    this.aktIndexHamster = 
      new MarkierungsHamster(this.getReihe() + 1, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.aktIndexHamster.erlaeuterung(
      "Ich markiere jeweils den Koernerhaufen,\n" +
      "der an der richtigen Position eingefuegt werden soll.");
    this.anzahlDeponierteKoerner = 0;
    this.anzahlTeilArrayMarkierungsHamster = 0;
  }

  // Der Standard-Hamster steht mit Blickrichtung OST irgendwo im Territorium. 
  // Ein Vertretungshamster soll die Koernerhaufen bis zur nchsten Wand in 
  // aufsteigender Reihenfolge sortieren. 
  // Voraussetzung: Unterhalb des Standard-Hamsters existieren drei nicht 
  // durch Mauern blockierte Reihen.
  public void sortiereKoernerHaufen() {
    this.erlaeuterung(
      "Ich zaehle nun die Anzahl der zu sortierenden Koernerhaufen.");
    this.anzahlKoernerHaufen = ermittleAnzahlKoernerHaufen();
    this.erlaeuterung(
      "Die Anzahl der zu sortierenden Koernerhaufen betraegt " +
      this.anzahlKoernerHaufen +
      ",\nd.h. die Indizes der Haufen liegen zwischen 0 und " +
      (this.anzahlKoernerHaufen-1) +
      ".");
    this.distanzHamster = new MarkierungsHamster[anzahlKoernerHaufen];
    for (int i=0; i<this.distanzHamster.length; i++) {
      this.distanzHamster[i] = 
        new MarkierungsHamster(this.getReihe() + 2, this.getSpalte(), 
                               this.getReihe(), mitErlaeuterungen);
      if (i == 0) {
        this.distanzHamster[0].erlaeuterung(
          "Wir sind fr die Anzeige der Distanzen zustaendig.\n" +
          "Wir markieren dazu die Elemente des zu sortierenden Teil-Arrays.");
      }                                            
    }
    sortiereKoernerHaufen(new KnuthDistanz(anzahlKoernerHaufen));
    //sortiereKoernerHaufen(new PapernovStasevichDistanz(anzahlKoernerHaufen));
    //sortiereKoernerHaufen(new ShellDistanz(anzahlKoernerHaufen));
  }

  // ShellSort fuer eine bestimmte Distanzfolge
  private void sortiereKoernerHaufen(Distanz distanzObjekt) {
	int distanz = distanzObjekt.berechneNaechsteDistanz();
	while (distanz > 0) {
      teilArrayMarkierungVorbereiten(distanz);
	  for (int abIndex = 0; abIndex < distanz; abIndex++) {
        if (abIndex+distanz < this.anzahlKoernerHaufen) {
          this.erlaeuterung(
            "Es folgt die Sortierung des Teil-Arrays ab Index " +
            abIndex +
            " mit der Distanz " +
            distanz +
            ".");
          insertionSort(abIndex, distanz);
          if (abIndex+1 < distanz) {
            teilArrayMarkierungsHamsterVorruecken();
          }
        }
      }
      this.erlaeuterung("Das Array ist nun " + distanz + "-sortiert!");
      distanz = distanzObjekt.berechneNaechsteDistanz();
	}
    beendeSortierung();
  }

  private void insertionSort(int abIndex, int distanz) {
    // durchlaufe die Menge der Koernerhaufen von links nach rechts;
    // merke dir den aktuellen Koernerhaufen
    for (int aktIndex = abIndex+distanz; 
         aktIndex < this.anzahlKoernerHaufen; 
         aktIndex += distanz) {
      this.aktIndexHamster.markiereIndex(aktIndex);
      this.erlaeuterung(
        "Ich suche nun den Einfuegeindex des markierten " +
        "Koernerhaufens bei Index " +
        this.aktIndexHamster.liefereIndex() +
        ".\nDazu deponiere ich zunaechst die " +
        this.aktIndexHamster.liefereAnzahlKoerner() +
        " Koerner des markierten Koernerhaufens.");
      this.deponiereKoerner();
      this.erlaeuterung(
        "Die aktuelle Distanz betraegt " + 
        distanz +
        ".\nIch suche nun im aktuell markierten Teil-Array " +
        "zwischen den Indizes 0 und " +
        (aktIndex-1) +
        " den ersten Koernerhaufen von rechts,\n" +
        " der weniger oder gleich " +
        this.anzahlDeponierteKoerner +
        " Koerner besitzt.\n" +
        distanz + 
        " Indizes rechts von diesem befindet sich der Einfuegeindex.\n" +
        "Groessere Haufen verschiebe ich dabei jeweils um " +
        distanz + 
        " Indizes nach rechts.");
      int einfuegeIndex = this.sucheEinfuegeIndex(distanz);
      this.erlaeuterung(
        "Einfuegeindex gefunden. Er lautet " +
        einfuegeIndex + 
         ".\nIch hole nun die deponierten Koerner und lege sie hier ab.");
      this.fuegeDeponierteKoernerEin(einfuegeIndex);
    }
  }

  private void deponiereKoerner() {
    // die Koerner werden drei Reihen darunter deponiert
    this.laufeZuIndex(this.aktIndexHamster.liefereIndex());
    this.anzahlDeponierteKoerner = this.nimmAlle();
    this.setzeBlickrichtung(Hamster.SUED);
    this.vor(3);
    this.gib(this.anzahlDeponierteKoerner);
    this.kehrt();
    this.vor(3);
    this.linksUm();
  }

  private int sucheEinfuegeIndex(int distanz) {
    // sucht und liefert den Index der Koernerhaufen, wo 
    // der aktuelle Koernerhaufen - sprich die deponierten Koerner -
    // eingefuegt werden muss, und verschiebt alle
    // greren Koernerhaufen jeweils um eine Position nach rechts
    this.vor(distanz);
    int tatsaechlicheSchritte = distanz;
    while (this.liefereIndex() >= 0 &&
           this.liefereAnzahlKoerner() > this.anzahlDeponierteKoerner) {
      int anzahl = this.nimmAlle();
      this.kehrt();
      this.vor(distanz);
      this.gib(anzahl);
      this.kehrt();
      this.vor(distanz);
      tatsaechlicheSchritte = this.vor(distanz);
    }
    return this.getSpalte() - this.startSpalte + tatsaechlicheSchritte - 1;
  }

  private void fuegeDeponierteKoernerEin(int index) {
    // holt die deponierten Koerner und fuegt sie an der uebergebenen
    // Position in die Menge der Koernerhaufen ein
    this.laufeZuKachel(this.getReihe() + 3, this.aktIndexHamster.getSpalte());
    int anzahl = this.nimmAlle();
    this.laufeZuKachel(this.getReihe() - 3, this.startSpalte + index + 1);
    this.gib(anzahl);
  }

  private void beendeSortierung() {
    this.laufeZuSpalte(this.startSpalte);
    this.setzeBlickrichtung(Hamster.OST);
    this.erlaeuterung("Sortierung erfolgreich beendet!");
  }

  private void teilArrayMarkierungVorbereiten(int distanz) {
    // die Distanz-Markierungshamster markieren das aktuelle Teil-Array
    for (int i=0; i<this.distanzHamster.length; i++) {
      this.distanzHamster[i].laufeZuStartSpalte();
    }
    this.erlaeuterung("Im naechsten Durchlauf ist die Distanz " +
                      distanz +
                      ".");
    int index = 0;
    this.anzahlTeilArrayMarkierungsHamster = 0;
    while (index < this.anzahlKoernerHaufen) {
      this.distanzHamster[this.anzahlTeilArrayMarkierungsHamster].
        markiereIndex(index);
      index += distanz;
      this.anzahlTeilArrayMarkierungsHamster++;
    }
  }

  private void teilArrayMarkierungsHamsterVorruecken() {
    for (int i=0; i<this.anzahlTeilArrayMarkierungsHamster; i++) {
      if (this.distanzHamster[i].liefereIndex()+1 < this.anzahlKoernerHaufen) {
        this.distanzHamster[i].markiereIndex(
          this.distanzHamster[i].liefereIndex()+1);
      } else {
        this.distanzHamster[i].laufeZuStartSpalte();
        this.anzahlTeilArrayMarkierungsHamster--;
      }
    }
  }
}

// Berechnung der ShellSort-Distanz
interface Distanz {
	public int berechneNaechsteDistanz();
}

// Distanz nach D.L. Shell (1959)
class ShellDistanz implements Distanz {

	int distanz;

	ShellDistanz(int arrayLaenge) {
		this.distanz = 1;
		while (this.distanz < arrayLaenge) {
			this.distanz = this.distanz * 2;
		}
	}

	public int berechneNaechsteDistanz() {
		this.distanz = this.distanz / 2;
		return this.distanz;
	}
}

// Distanz nach Papernov-Stasevich (1965)
class PapernovStasevichDistanz implements Distanz {

	int distanz;

	PapernovStasevichDistanz(int arrayLaenge) {
		this.distanz = 1;
		while (this.distanz < arrayLaenge) {
			this.distanz = (this.distanz + 1) * 2 - 1;
		}
	}

	public int berechneNaechsteDistanz() {
		this.distanz = (this.distanz + 1) / 2 - 1;
		return this.distanz;
	}
}

// Distanz nach Knuth
class KnuthDistanz implements Distanz {

	int distanz;

	KnuthDistanz(int arrayLaenge) {
		this.distanz = 1;
		while (this.distanz < arrayLaenge) {
			this.distanz = this.distanz * 3 + 1;
		}
	}

	public int berechneNaechsteDistanz() {
		this.distanz = (this.distanz - 1) / 3;
		return this.distanz;
	}
}
