import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class ShellSort implements SortierAlgorithmus {

  // sortiert das uebergebene Array in aufsteigender Reihenfolge
  // gemaess dem ShellSort-Algorithmus
  public void sortiere(int[] zahlen) {
    sortiere(zahlen, new ShellDistanz(zahlen.length));
    //sortiere(zahlen, new PapernovStasevichDistanz(zahlen.length));
    //sortiere(zahlen, new KnuthDistanz(zahlen.length));
  }

  // sortiert das uebergebene Array in aufsteigender Reihenfolge
  // gemaess dem ShellSort-Algorithmus und der uebergebenen Distanz
  public void sortiere(int[] zahlen, Distanz distanzObjekt) {
    int distanz = distanzObjekt.berechneNaechsteDistanz();
    while (distanz > 0) {
      for (int abIndex = 0; abIndex < distanz; abIndex++) {
        insertionSort(zahlen, abIndex, distanz);
      }
      distanz = distanzObjekt.berechneNaechsteDistanz();
    }
  }

  // analog dem InsertionSort-Algorithmus; es werden jedoch nur die
  // Elemente ab "abIndex" beruecksichtigt, die voneinander eine
  // Entfernung "distanz" haben
  public void insertionSort(int[] zahlen, int abIndex, int distanz) {
    // durchlaufe alle Zahlen ab der zweiten
    for (int aktIndex = abIndex+distanz; 
             aktIndex < zahlen.length; 
             aktIndex += distanz) {
      int aktuelleZahl = zahlen[aktIndex];
      int einfuegeIndex =
        sucheEinfuegeIndex(zahlen, aktuelleZahl, aktIndex, distanz);
      zahlen[einfuegeIndex] = aktuelleZahl;
    }
  }

  // sucht und liefert vor der aktuellen Zahl den Index des Arrays, wo 
  // die aktuelle Zahl eingefuegt werden muss, und verschiebt alle
  // greren Zahlen jeweils um "distanz" Positionen nach hinten im Array
  private int sucheEinfuegeIndex(int[] zahlen, int zahl,
                                   int aktIndex, int distanz) {
    int vergleichsIndex = aktIndex - distanz;
    while (vergleichsIndex >= 0 && zahlen[vergleichsIndex] > zahl) {
      // Zahl im Array um eine Position nach hinten verschieben
      zahlen[vergleichsIndex + distanz] = zahlen[vergleichsIndex];
      vergleichsIndex -= distanz;
    }
    return vergleichsIndex + distanz;
  }

  /* der ShellSort-Algorithmus in kompakter Form
  public void sortiere(int[] zahlen, Distanz distanzObjekt) {
    int distanz = distanzObjekt.berechneNaechsteDistanz();
    while (distanz > 0) {
      for (int abIndex = 0; abIndex < distanz; abIndex++) {
        for (int aktIndex=abIndex+distanz; 
                     aktIndex < zahlen.length; 
                     aktIndex += distanz) {
          int aktuelleZahl = zahlen[aktIndex];
          int vergleichsIndex = aktIndex-distanz;
          while (vergleichsIndex >= 0 && zahlen[vergleichsIndex] > aktuelleZahl) {
            zahlen[vergleichsIndex+distanz] = zahlen[vergleichsIndex];
            vergleichsIndex -= distanz;
          }
          zahlen[vergleichsIndex+distanz] = aktuelleZahl;
        }
      }
      distanz = distanzObjekt.berechneNaechsteDistanz();
    }
  }
  */
}

// Berechnung der ShellSort-Distanz
interface Distanz {
  public int berechneNaechsteDistanz();
}

// Distanz nach D.L. Shell (1959)
class ShellDistanz implements Distanz {

  int distanz;

  ShellDistanz(int arrayLaenge) {
    this.distanz = 1;
    while (this.distanz < arrayLaenge) {
      this.distanz = this.distanz * 2;
    }
  }

  public int berechneNaechsteDistanz() {
    this.distanz = this.distanz / 2;
    return this.distanz;
  }
}

// Distanz nach Papernov-Stasevich (1965)
class PapernovStasevichDistanz implements Distanz {

  int distanz;

  PapernovStasevichDistanz(int arrayLaenge) {
    this.distanz = 1;
    while (this.distanz < arrayLaenge) {
      this.distanz = (this.distanz + 1) * 2 - 1;
    }
  }

  public int berechneNaechsteDistanz() {
    this.distanz = (this.distanz + 1) / 2 - 1;
    return this.distanz;
  }
}

// Distanz nach Knuth
class KnuthDistanz implements Distanz {

  int distanz;

  KnuthDistanz(int arrayLaenge) {
    this.distanz = 1;
    while (this.distanz < arrayLaenge) {
      this.distanz = this.distanz * 3 + 1;
    }
  }

  public int berechneNaechsteDistanz() {
    this.distanz = (this.distanz - 1) / 3;
    return this.distanz;
  }
}
