// Demonstration des SelectionSort-Algorithmus
import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class SelectionSortHamster 
  extends KoernerHaufenSortierHamster
  implements SortierHamster
{

  private MarkierungsHamster aktIndexHamster = null;
    // markiert den Start des unsortierten Teils

  private MarkierungsHamster minIndexHamster = null;
    // markiert den jeweils kleinsten Koernerhaufen im unsortierten Teil

  private int anzahlKoernerHaufen = 0;
    // Anzahl der zu sortierenden Koernerhaufen

  // Konstruktor
  public SelectionSortHamster(boolean mitErlaeuterungen) {
    super(mitErlaeuterungen);
    this.erlaeuterung(
      "Ich sortiere die Koernerhaufen auf der Basis des " +
      "SelectionSort-Algorithmus.");
    this.aktIndexHamster = 
      new MarkierungsHamster(this.getReihe()+1, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.aktIndexHamster.erlaeuterung(
      "Ich markiere den linken Koernerhaufen des unsortierten Teils.");
    this.minIndexHamster = 
      new MarkierungsHamster(this.getReihe()+2, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.minIndexHamster.erlaeuterung(
      "Ich markiere den aktuell kleinsten Koernerhaufen im unsortierten Teil.");
  }

  // Der Standard-Hamster steht mit Blickrichtung OST irgendwo im Territorium. 
  // Ein Vertretungshamster soll die Koernerhaufen bis zur nchsten Wand in 
  // aufsteigender Reihenfolge sortieren. 
  // Voraussetzung: Unterhalb des Standard-Hamsters existieren zwei nicht 
  // durch Mauern blockierte Reihen.
  public void sortiereKoernerHaufen() {
    this.erlaeuterung(
      "Ich zaehle nun die Anzahl der zu sortierenden Koernerhaufen.");
    this.anzahlKoernerHaufen = this.ermittleAnzahlKoernerHaufen();
    this.erlaeuterung(
      "Die Anzahl der zu sortierenden Koernerhaufen betraegt " +
      this.anzahlKoernerHaufen +
      ",\nd.h. die Indizes der Haufen liegen zwischen 0 und " +
      (this.anzahlKoernerHaufen-1) +
      ".");

    // durchlaufe die Menge der Koernerhaufen von links nach rechts;
    // merke dir den aktuellen Koernerhaufen
    for (int aktIndex=0; aktIndex<this.anzahlKoernerHaufen-1; aktIndex++) {
      // suche den kleinsten Koernerhaufen im unsortierten Teil
      this.sucheMinKoernerHaufen(aktIndex);
      // tausche den aktuellen Koernerhaufen mit dem kleinsten
      // Koernerhaufen im unsortierten Teil
      this.aktUndMinKoernerHaufenTauschen();
      this.erlaeuterung(
        "Die Koernerhaufen zwischen den Indizes 0 und " +
        aktIndex +  
        " sind nun sortiert.");
    }
    beendeSortierung();
  }

  private void sucheMinKoernerHaufen(int aktIndex) {
    // zunaechst ist der aktuelle Koernerhaufen auch der kleinste
    // im unsortierten Teil
    this.aktIndexHamster.markiereIndex(aktIndex);
    this.minIndexHamster.markiereIndex(aktIndex);
    this.erlaeuterung(
      "Ich suche nun den kleinsten Koernerhaufen im unsortierten Teil,\n" +
      "d.h. zwischen den Indizes " +
      aktIndex + 
      " und " + 
      (this.anzahlKoernerHaufen-1) + 
      ".");
    // suche im unsortierten Teil der Koernerhaufen den kleinsten
    for (int suchIndex=aktIndex+1; 
         suchIndex<this.anzahlKoernerHaufen; 
         suchIndex++) {
      this.laufeZuIndex(suchIndex);
      if (this.liefereAnzahlKoerner() < 
          this.minIndexHamster.liefereAnzahlKoerner()) {
        // neuer kleinster Koernerhaufen gefunden
        this.minIndexHamster.markiereIndex(suchIndex);
      }
    }
    this.erlaeuterung(
      "Der kleinste Koernerhaufen zwischen den Indizes " +
      aktIndex +  
      " und " + 
      (this.anzahlKoernerHaufen-1) + 
      " befindet sich bei Index " + 
      this.minIndexHamster.liefereIndex() +
      ".");
  }

  private void aktUndMinKoernerHaufenTauschen() {
    if (this.aktIndexHamster.liefereIndex() !=
        this.minIndexHamster.liefereIndex()) {
      this.erlaeuterung(
        "Ich tausche nun die markierten Koernerhaufen der Indizes " +
        this.aktIndexHamster.liefereIndex() + 
        " und " + 
        this.minIndexHamster.liefereIndex() + 
        ".");
      this.laufeZuIndex(this.minIndexHamster.liefereIndex());
      int minKoerner = this.nimmAlle();
      this.laufeZuIndex(this.aktIndexHamster.liefereIndex());
      int aktKoerner = this.nimmAlle();
      this.gib(minKoerner);
      this.laufeZuIndex(this.minIndexHamster.liefereIndex());
      this.gib(aktKoerner);
    } else {
      this.erlaeuterung(
        "Der Koernerhaufen links im unsortierten Teil ist auch der kleinste.\n" +
        "Daher brauche ich nicht zu tauschen.");
    }
  }

  private void beendeSortierung() {
    this.laufeZuSpalte(this.startSpalte);
    this.setzeBlickrichtung(Hamster.OST);
    this.erlaeuterung("Sortierung erfolgreich beendet!");
  }
}