import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class SelectionSort implements SortierAlgorithmus {

  // sortiert das bergebene Array in aufsteigender Reihenfolge
  // gemaess dem SelectionSort-Algorithmus
  public void sortiere(int[] zahlen) {
    for (int aktIndex = 0; aktIndex < zahlen.length - 1; aktIndex++) {
      int minIndex = sucheKleinstesElement(zahlen, aktIndex);
      tauscheElemente(zahlen, aktIndex, minIndex);
    }
  }

  // sucht im Array ab dem angegebenen Index das kleinste Element
  // und liefert dessen Index
  private int sucheKleinstesElement(int[] zahlen, int abIndex) {
    int minIndex = abIndex;
    for (int suchIndex = abIndex+1; suchIndex < zahlen.length; suchIndex++) {
      if (zahlen[suchIndex] < zahlen[minIndex]) {
        // neues kleinstes Element gefunden
        minIndex = suchIndex;
      }
    }
    return minIndex;
  }

  // vertauscht im Array die Elemente der angegebenen Indizes
  private void tauscheElemente(int[] zahlen, int index1, int index2) {
    int speicher = zahlen[index1];
    zahlen[index1] = zahlen[index2];
    zahlen[index2] = speicher;
  }

  /* der SelectionSort-Algorithmus in kompakter Form
  public void selection(int[] zahlen) {
    for (int aktIndex = 0; aktIndex < zahlen.length - 1; aktIndex++) {
      int minIndex = aktIndex;
      for (int suchIndex = aktIndex+1; suchIndex < zahlen.length; suchIndex++) {
        if (zahlen[suchIndex] < zahlen[minIndex]) {
          minIndex = suchIndex;
        }
      }
      int speicher = zahlen[aktIndex];
      zahlen[aktIndex] = zahlen[minIndex];
      zahlen[minIndex] = speicher;
    }
  }
  */
}