// Demonstration des QuickSort-Algorithmus
import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class QuickSortHamster 
  extends KoernerHaufenSortierHamster
  implements SortierHamster
{

  private MarkierungsHamster linkerIndexHamster = null;
    // markiert den linken Rand des aktuellen Teil-Arrays

  private MarkierungsHamster rechterIndexHamster = null;
    // markiert den rechten Rand des aktuellen Teil-Arrays
    // (gleichzeitig auch das Pivot-Element!)

  private MarkierungsHamster linkerZeigerHamster = null;
    // markiert waehrend der Partitionierung das aktuell
    // betrachtete linke Element

  private MarkierungsHamster rechterZeigerHamster = null;
    // markiert waehrend der Partitionierung das aktuell
    // betrachtete rechte Element

  private int anzahlKoernerHaufen = 0;
    // Anzahl der zu sortierenden Koernerhaufen

  // Konstruktor
  public QuickSortHamster(boolean mitErlaeuterungen) {
    super(mitErlaeuterungen);
    this.erlaeuterung(
      "Ich sortiere die Koernerhaufen auf der Basis des QuickSort-Algorithmus.");
    this.linkerIndexHamster = 
      new MarkierungsHamster(this.getReihe()+1, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.linkerIndexHamster.erlaeuterung(
      "Ich markiere den linken Rand des aktuell betrachteten Teil-Arrays.");
    this.rechterIndexHamster = 
      new MarkierungsHamster(this.getReihe()+1, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.rechterIndexHamster.erlaeuterung(
     "Ich markiere den rechten Rand des aktuell betrachteten Teil-Arrays " +
     " und\ngleichzeitig auch den aktuellen Pivot-Haufen.");
    this.linkerZeigerHamster = 
      new MarkierungsHamster(this.getReihe()+2, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.linkerZeigerHamster.erlaeuterung(
      "Ich markiere waehrend der Partitionierung den aktuell " +
      "betrachteten linken Haufen.");
    this.rechterZeigerHamster = 
      new MarkierungsHamster(this.getReihe()+2, this.getSpalte(), 
                             this.getReihe(), mitErlaeuterungen);
    this.rechterZeigerHamster.erlaeuterung(
      "Ich markiere waehrend der Partitionierung den aktuell " +
      "betrachteten rechten Haufen.");
  }

  // Der Standard-Hamster steht mit Blickrichtung OST irgendwo im Territorium. 
  // Ein Vertretungshamster soll die Koernerhaufen bis zur nchsten Wand in 
  // aufsteigender Reihenfolge sortieren. 
  // Voraussetzung: Unterhalb des Standard-Hamsters existieren zwei nicht 
  // durch Mauern blockierte Reihen.
  public void sortiereKoernerHaufen() {
    this.erlaeuterung(
     "Ich zaehle nun die Anzahl der zu sortierenden Koernerhaufen.");
    this.anzahlKoernerHaufen = this.ermittleAnzahlKoernerHaufen();
    this.erlaeuterung(
      "Die Anzahl der zu sortierenden Koernerhaufen betraegt " +
      this.anzahlKoernerHaufen +
      ",\nd.h. die Indizes der Haufen liegen zwischen 0 und " +
      (this.anzahlKoernerHaufen-1) +
      ".");
    this.quickSort(0, this.anzahlKoernerHaufen-1);
    this.beendeSortierung();
  }
  
  // der Quicksort-Algorithmus wird auf dem Array zwischen den
  // angegebenen Indizes ausgefuehrt 
  private void quickSort(int linkerIndex, int rechterIndex) {
    if (linkerIndex < rechterIndex) {
      this.linkerIndexHamster.markiereIndex(linkerIndex);
      this.rechterIndexHamster.markiereIndex(rechterIndex);
      this.erlaeuterung(
        "Ich partitioniere nun das Teil-Array zwischen den Indizes " +
        linkerIndex +
        " und " +
        rechterIndex +
        ".");
      int pivotIndex = zerlege(linkerIndex, rechterIndex);
      this.erlaeuterung(
        "Die Partitionierung des Teil-Arrays zwischen den Indizes " +
        linkerIndex +
        " und " +
        rechterIndex + 
        " ist abgeschlossen.\n" +
        "Der Pivot-Haufen befindet sich bei Index " + 
        pivotIndex + 
        ".");
      quickSort(linkerIndex, pivotIndex-1);
      quickSort(pivotIndex+1, rechterIndex);
    }
  }

  // liefert den Index des Pivot-Elementes und ordnet das Array innerhalb
  // der angegebenen Indizes so um, dass alle Zahlen links vom Index
  // kleiner oder gleich und alle Zahlen rechts vom Index groesser 
  // oder gleich dem Pivot-Element sind
  private int zerlege(int linkerIndex, int rechterIndex) {
    int pivotIndex = waehlePivotIndex(linkerIndex, rechterIndex);
    this.laufeZuIndex(pivotIndex);
    int pivotWert = this.liefereAnzahlKoerner();
    this.erlaeuterung(
      "Ich stehe nun auf dem Pivot-Haufen. Hier liegen " + 
      pivotWert + 
      " Koerner.");
    // das Pivot-Element kommt nach ganz rechts ins Array
    this.erlaeuterung(
      "Ich tausche nun den Pivot-Haufen mit dem rechten " +
      "Haufen des\naktuellen Teil-Arrays (gelber Markierungshamster).");
    this.tauschen(pivotIndex, rechterIndex);
    int l = linkerIndex-1;
    this.linkerZeigerHamster.markiereIndex(l);
    int r = rechterIndex;
    this.rechterZeigerHamster.markiereIndex(r);
    // ordne das Array so um, dass jeweils alle Elemente links vom Zeiger l 
    // kleiner gleich und alle Elemente rechts vom Zeiger r groesser
    // gleich dem Pivot-Element sind
    this.erlaeuterung(
      "Das Teil-Array zwischen den Indizes " +
      linkerIndex + 
      " und " + 
      rechterIndex +
      " wird nun so umgeordnet,\ndass jeweils alle Haufen links vom " +
      "hellblauen Markierungshamster kleiner gleich\n" +
      "und alle Elemente rechts vom violetten Markierungshamster " +
      "groesser gleich\ndem Pivot-Haufen (gelber Markierungshamster) sind.");
    do {
      l++;
      this.linkerZeigerHamster.markiereIndex(l);
      while (l <= rechterIndex && 
             this.linkerZeigerHamster.liefereAnzahlKoerner() <= pivotWert) {
        l++;
        this.linkerZeigerHamster.markiereIndex(l);
      }
      r--;
      this.rechterZeigerHamster.markiereIndex(r);
      while (r >= linkerIndex && 
             this.rechterZeigerHamster.liefereAnzahlKoerner() >= pivotWert) {
        r--;
        this.rechterZeigerHamster.markiereIndex(r);
      }
      if (l < r) {
        this.erlaeuterung(
          "Der Haufen bei Index " + 
          l +
          " ist groesser als der Pivot-Haufen\nund der Haufen bei Index " +
          r +
          " ist kleiner als der Pivot-Haufen.\nSie werden daher getauscht.");
        tauschen(l, r);
      }
    } while (l < r);
    // platziere das Pivot-Element an seine korrekte Position
    if (l < rechterIndex) {
      this.erlaeuterung(
        "Die Umordnung des Teil-Arrays ist abgeschlossen.\n" +
        "Nun muss ich nur noch den Pivot-Haufen (gelber Markierungshamster) " +
        "an seine\nkorrekte Position bei Index " + 
        l +
        " (hellblauer Markierungshamster) stellen.");
      tauschen(l, rechterIndex);
      return l;
    } else {
      this.erlaeuterung(
        "Die Umordnung des Teil-Arrays ist abgeschlossen.\n" +
        "Auch der Pivot-Haufen steht bereits an seiner korrekten " +
        "Position bei Index " + 
        rechterIndex + 
        ".");
      return rechterIndex;
    }
  }

  // waehlt einen beliebigen Index zwischen den angegebenen Indizes
  private int waehlePivotIndex(int linkerIndex, int rechterIndex) {
    // in diesem Fall einfach der mittleren Index
    return (linkerIndex + rechterIndex) / 2;
    /* Alternative 1: 
      return rechterIndex;
    */
    /* Alternative 2 (mittleres von drei Elementen):
      int index1 = (linkerIndex + rechterIndex) / 2;
      int index2 = (linkerIndex + index1) / 2;
      int index3 = (index1 + rechterIndex) / 2;
      if (zahlen[index1] <= zahlen[index2] &&
          zahlen[index2] <= zahlen[index3])
        return zahlen[index2];
      if (zahlen[index2] <= zahlen[index3] &&
          zahlen[index3] <= zahlen[index1])
        return zahlen[index3];
      return zahlen[index1];
    */
  }

  // tauscht die Elemente des Arrays an den angegebenen Indizes
  private void tauschen(int index1, int index2) {
    if (index1 != index2) {
      this.laufeZuIndex(index1);
      int koerner1 = this.nimmAlle();
      this.laufeZuIndex(index2);
      int koerner2 = nimmAlle();
      this.gib(koerner1);
      this.laufeZuIndex(index1);
      this.gib(koerner2);
    }
  }

  private void beendeSortierung() {
    this.laufeZuSpalte(this.startSpalte);
    this.setzeBlickrichtung(Hamster.OST);
    this.erlaeuterung("Sortierung erfolgreich beendet!");
  }
}
