// Demonstration des MergeSort-Algorithmus
import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class MergeSortHamster 
  extends KoernerHaufenSortierHamster
  implements SortierHamster
{

  private MarkierungsHamster linkerIndexHamster = null;
    // markiert den linken Rand des aktuellen Teil-Arrays

  private MarkierungsHamster rechterIndexHamster = null;
    // markiert den rechten Rand des aktuellen Teil-Arrays

  private MarkierungsHamster linkerZeigerHamster = null;
    // markiert waehrend des Mischens das aktuell
    // betrachtete Element des ersten Teil-Arrays

  private MarkierungsHamster rechterZeigerHamster = null;
    // markiert waehrend des Mischens das aktuell
    // betrachtete Element des rechten Teil-Arrays

  private MarkierungsHamster aktuellerZeigerHamster = null;
    // markiert waehrend der Partitionierung das aktuell
    // betrachtete rechte Element

  private int anzahlKoernerHaufen = 0;
    // Anzahl der zu sortierenden Koernerhaufen

  // Konstruktor
  public MergeSortHamster(boolean mitErlaeuterungen) {
    super(mitErlaeuterungen);
    this.erlaeuterung(
      "Ich sortiere die Koernerhaufen auf der Basis des MergeSort-Algorithmus.");
    this.linkerIndexHamster = 
      new MarkierungsHamster(this.getReihe()+1, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.linkerIndexHamster.erlaeuterung(
      "Ich markiere den linken Rand des aktuell betrachteten Teil-Arrays.");
    this.rechterIndexHamster = 
      new MarkierungsHamster(this.getReihe()+1, this.getSpalte(), 
                             this.getReihe(), mitErlaeuterungen);
    this.rechterIndexHamster.erlaeuterung(
      "Ich markiere den rechten Rand des aktuell betrachteten Teil-Arrays.");
    this.linkerZeigerHamster = 
      new MarkierungsHamster(this.getReihe()+3, this.getSpalte(), 
                             this.getReihe()+2, mitErlaeuterungen);
    this.linkerZeigerHamster.erlaeuterung(
      "Ich markiere waehrend des Mischens das aktuell betrachtete Element\n" +
      "des ersten Teils der Hilfskoernerhaufenreihe.");
    this.rechterZeigerHamster = 
      new MarkierungsHamster(this.getReihe()+3, this.getSpalte(),
                             this.getReihe()+2, mitErlaeuterungen);
    this.rechterZeigerHamster.erlaeuterung(
      "Ich markiere waehrend des Mischens das aktuell betrachtete Element\n" +
      "des zweiten Teils der Hilfskoernerhaufenreihe.");
    this.aktuellerZeigerHamster = 
      new MarkierungsHamster(this.getReihe()+1, this.getSpalte(), 
                             this.getReihe(), mitErlaeuterungen);
    this.aktuellerZeigerHamster.erlaeuterung(
      "Ich markiere waehrend des Mischens das Element der Krnerhaufenreihe,\n" +
      "in das die Krner der Hilfskoernerhaufenreihe zurueckkopiert werden.");
  }

  // Der Standard-Hamster steht mit Blickrichtung OST irgendwo im Territorium. 
  // Ein Vertretungshamster soll die Koernerhaufen bis zur nchsten Wand in 
  // aufsteigender Reihenfolge sortieren. 
  // Voraussetzung: Unterhalb des Standard-Hamsters existieren drei nicht 
  // durch Mauern blockierte Reihen.
  public void sortiereKoernerHaufen() {
    this.erlaeuterung(
      "Ich zaehle nun die Anzahl der zu sortierenden Koernerhaufen.");
    this.anzahlKoernerHaufen = this.ermittleAnzahlKoernerHaufen();
    this.erlaeuterung(
      "Die Anzahl der zu sortierenden Koernerhaufen betraegt " +
      this.anzahlKoernerHaufen +
      ",\nd.h. die Indizes der Haufen liegen zwischen 0 und " +
      (this.anzahlKoernerHaufen-1) +
      ".");
    this.mergeSort(0, this.anzahlKoernerHaufen-1);
    this.beendeSortierung();
  }
  
  // der MergeSort-Algorithmus wird auf dem Array zwischen den
  // angegebenen Indizes ausgefuehrt 
  private void mergeSort(int linkerIndex, int rechterIndex) {
    if (linkerIndex < rechterIndex) {
      int mittlererIndex = (linkerIndex + rechterIndex) / 2;
      mergeSort(linkerIndex, mittlererIndex);
      this.erlaeuterung(
        "Die Koernerhaufen von Index " +
        linkerIndex + " bis " + mittlererIndex + 
        " sind (nun) sortiert.");
      mergeSort(mittlererIndex+1, rechterIndex);
      this.erlaeuterung(
        "Die Koernerhaufen von Index " +
        (mittlererIndex+1) + " bis " + rechterIndex + 
        " sind (nun) sortiert.");
      mischen(linkerIndex, mittlererIndex, rechterIndex);
    } else {
      this.linkerIndexHamster.markiereIndex(linkerIndex);
      this.rechterIndexHamster.markiereIndex(rechterIndex);
    }
  }

  // mischt die zwei (sortierten) Teil-Arrays von linkerIndex bis 
  // mittlererIndex und mittlererIndex+1 bis rechterIndex
  private void mischen(int linkerIndex, int mittlererIndex, 
                       int rechterIndex) {
    this.linkerIndexHamster.markiereIndex(linkerIndex);
    this.rechterIndexHamster.markiereIndex(rechterIndex);
    this.erlaeuterung(
      "Es folgt nun das Mischen der Koernerhaufen von Index " +
      linkerIndex + " bis " + mittlererIndex + 
      " und " +
      (mittlererIndex+1) + " bis " + rechterIndex + 
      ".\n" +
      "Zunaechst werden dazu die Koernerhaufen in eine Hilfsreihe verschoben.");

    // beide Teil-Arrays in das Hilfsarray (zwei Zeilen darunter) kopieren
    int linkerZeiger = linkerIndex;
    this.linkerZeigerHamster.markiereIndex(linkerZeiger);
    int rechterZeiger = mittlererIndex + 1; 
    this.rechterZeigerHamster.markiereIndex(rechterZeiger);

    for (int i=linkerIndex; i<=rechterIndex; i++) {
      this.laufeZuIndex(i);
      int koerner = this.nimmAlle();
      this.setzeBlickrichtung(Hamster.SUED);
      this.vor(2);
      this.gib(koerner);
      this.setzeBlickrichtung(Hamster.NORD);
      this.vor(2);
    }

    // jeweils das kleinere Element der beiden Teil-Arrays zurckkopieren
    int aktuellerZeiger = linkerIndex;
    this.aktuellerZeigerHamster.markiereIndex(aktuellerZeiger);
    this.erlaeuterung(
      "Beim Mischen wird der kleinere der beiden markierten " +
      "Koernerhaufen der Hilfsreihe an\ndie markierte Kachel der " +
      "eigentlichen Reihe (weier Markierungshamster) zurueckkopiert.");

    while (linkerZeiger <= mittlererIndex && rechterZeiger <= rechterIndex) {
      if (linkerZeigerHamster.liefereAnzahlKoerner() <=
          rechterZeigerHamster.liefereAnzahlKoerner()) {
        transportiereKoerner(linkerZeigerHamster.liefereIndex());
        linkerZeiger++;
        this.linkerZeigerHamster.markiereIndex(linkerZeiger);
      } else {
        transportiereKoerner(rechterZeigerHamster.liefereIndex());
        rechterZeiger++;
        this.rechterZeigerHamster.markiereIndex(rechterZeiger);
      }
      aktuellerZeiger++;
      if (aktuellerZeiger <= rechterIndex) {
        this.aktuellerZeigerHamster.markiereIndex(aktuellerZeiger);
      }
    }

    // falls vorhanden Reste des ersten Teil-Arrays zurckkopieren
    while (linkerZeiger <= mittlererIndex) {
      transportiereKoerner(linkerZeigerHamster.liefereIndex());
      linkerZeiger++;
      this.linkerZeigerHamster.markiereIndex(linkerZeiger);
      aktuellerZeiger++;
      if (aktuellerZeiger <= rechterIndex) {
        this.aktuellerZeigerHamster.markiereIndex(aktuellerZeiger);
      }
    }

    // falls vorhanden Reste des zweiten Teil-Arrays zurckkopieren
    while (rechterZeiger <= rechterIndex) {
      transportiereKoerner(rechterZeigerHamster.liefereIndex());
      rechterZeiger++;
      this.rechterZeigerHamster.markiereIndex(rechterZeiger);
      aktuellerZeiger++;
      if (aktuellerZeiger <= rechterIndex) {
        this.aktuellerZeigerHamster.markiereIndex(aktuellerZeiger);
      }
    }
  }

  // transportiert die Koerner aus
  private void transportiereKoerner(int index) {
    this.laufeZuIndex(index);
    this.setzeBlickrichtung(Hamster.SUED);
    this.vor(2);
    int koerner = this.nimmAlle();
    this.setzeBlickrichtung(Hamster.NORD);
    this.vor(2);
    this.laufeZuIndex(aktuellerZeigerHamster.liefereIndex());
    this.gib(koerner);
  }

  private void beendeSortierung() {
    this.laufeZuSpalte(this.startSpalte);
    this.setzeBlickrichtung(Hamster.OST);
    this.erlaeuterung("Sortierung erfolgreich beendet!");
  }
}
