import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class MergeSort implements SortierAlgorithmus {

  private int[] hilfsArray;

  // sortiert das uebergebene Array in aufsteigender Reihenfolge
  // gemaess dem MergeSort-Algorithmus
  public void sortiere(int[] zahlen) {
    hilfsArray = new int[zahlen.length];
    mergeSort(zahlen, 0, zahlen.length-1);
  }
  
  // der MergeSort-Algorithmus wird auf dem Array zwischen den
  // angegebenen Indizes ausgefuehrt 
  private void mergeSort(int[] zahlen, int linkerIndex, int rechterIndex) {
    if (linkerIndex < rechterIndex) {
      int mittlererIndex = (linkerIndex + rechterIndex) / 2;
      mergeSort(zahlen, linkerIndex, mittlererIndex);
      mergeSort(zahlen, mittlererIndex+1, rechterIndex);
      mischen(zahlen, linkerIndex, mittlererIndex, rechterIndex);
    }
  }

  // mischt die zwei (sortierten) Teil-Arrays von linkerIndex bis 
  // mittlererIndex und mittlererIndex+1 bis rechterIndex
  private void mischen(int[] zahlen, int linkerIndex, int mittlererIndex, 
                      int rechterIndex) {

    // beide Teil-Arrays in das Hilfsarray kopieren
    for (int i=linkerIndex; i<=rechterIndex; i++) {
      hilfsArray[i] = zahlen[i];
    }

    // jeweils das kleinere Element der beiden Teil-Arrays zurckkopieren
    int linkerZeiger = linkerIndex;
    int rechterZeiger = mittlererIndex + 1; 
    int aktuellerZeiger = linkerIndex;
    while (linkerZeiger <= mittlererIndex && rechterZeiger <= rechterIndex) {
      if (hilfsArray[linkerZeiger] <= hilfsArray[rechterZeiger]) {
        zahlen[aktuellerZeiger++] = hilfsArray[linkerZeiger++];
      } else {
        zahlen[aktuellerZeiger++] = hilfsArray[rechterZeiger++];
      }
    }

    // falls vorhanden Reste des ersten Teil-Arrays zurckkopieren
    while (linkerZeiger <= mittlererIndex) {
      zahlen[aktuellerZeiger++] = hilfsArray[linkerZeiger++];
    }

    // falls vorhanden Reste des zweiten Teil-Arrays zurckkopieren
    while (rechterZeiger <= rechterIndex) {
      zahlen[aktuellerZeiger++] = hilfsArray[rechterZeiger++];
    }

  }
}