// zum Markieren bestimmter Koernerhaufen
import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class MarkierungsHamster extends AllroundHamster {

  private int startSpalte;
    // Spalte, in der der Hamster erzeugt wird

  private int koernerHaufenReihe;
    // Reihe, in der die Koernerhaufen liegen
	
  // Konstruktor
  public MarkierungsHamster(int reihe, int spalte, int koernerHaufenReihe,
                            boolean mitErlaeuterungen) {
    super(reihe, spalte, Hamster.NORD, 0, mitErlaeuterungen);
    this.startSpalte = spalte;
    this.koernerHaufenReihe = koernerHaufenReihe;
  }

  // laeuft zum angegebenen Koernerhaufenindex
  public void markiereIndex(int index) {
    this.laufeZuSpalte(this.startSpalte + index + 1);
    this.setzeBlickrichtung(Hamster.NORD);
  }

  // liefert den markierten Koernerhaufenindex
  public int liefereIndex() {
    return this.getSpalte() - this.startSpalte - 1;
  }

  // liefert die Anzahl an Koernern des markierten Koernerhaufens
  public int liefereAnzahlKoerner() {
    return 
      Territorium.getAnzahlKoerner(this.koernerHaufenReihe, this.getSpalte());
  }

  // kehrt zur Startspalte zurueck
  public void laufeZuStartSpalte() {
    this.laufeZuSpalte(this.startSpalte);
    this.setzeBlickrichtung(Hamster.NORD);
  }
}
