// Basisklasse der eigentlichen Hamster-Sortier-Klassen
import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class KoernerHaufenSortierHamster extends AllroundHamster {

  protected int startSpalte = 0;
    // Spalte, in der der Sortier-Hamster anfangs steht

  // Konstruktor
  protected KoernerHaufenSortierHamster(boolean erlaeuterungen) {
    super(Hamster.getStandardHamster(), erlaeuterungen);
    this.startSpalte = this.getSpalte();
  }

  // ermittelt und liefert die Anzahl der zu sortierenden
  // Koernerhaufen
  protected int ermittleAnzahlKoernerHaufen() {
    // bis zur naechsten Mauer
    int anzahlKoernerHaufen = 0;
    while (this.vornFrei()) {
      this.vor();
      anzahlKoernerHaufen++;
    }
    // und zurueck (Seiteneffekte beseitigen)
    this.kehrt();
    int speicher = anzahlKoernerHaufen;
    while (speicher > 0) {
      this.vor();
      speicher = speicher - 1;
    }
    this.kehrt();
    return anzahlKoernerHaufen;
  }

  // laeuft zum angegebenen Koernerhaufenindex
  protected void laufeZuIndex(int index) {
    this.laufeZuSpalte(this.startSpalte + index + 1);
  }

  // liefert den aktuellen Index des Koernerhaufens, auf dem der Hamster steht
  protected int liefereIndex() {
    return this.getSpalte() - this.startSpalte - 1;
  }

  // liefert die Anzahl an Koernern des Koernerhaufens, auf dem der Hamster steht
  protected int liefereAnzahlKoerner() {
    return Territorium.getAnzahlKoerner(this.getReihe(), this.getSpalte());
  }

}
