// Demonstration des InsertionSort-Algorithmus
import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class InsertionSortHamster
  extends KoernerHaufenSortierHamster
  implements SortierHamster 
{

  private MarkierungsHamster aktIndexHamster = null;
    // markiert den aktuell betrachteten Koernerhaufen

  private int anzahlKoernerHaufen = 0;
    // Anzahl der zu sortierenden Koernerhaufen

  private int anzahlDeponierteKoerner = 0;
    // Koerneranzahl des aktuellen Koernerhaufens

  // Konstruktor
  public InsertionSortHamster(boolean mitErlaeuterungen) {
    super(mitErlaeuterungen);
    this.erlaeuterung(
      "Ich sortiere die Koernerhaufen auf der Basis des " +
      "InsertionSort-Algorithmus.");
    this.aktIndexHamster = 
      new MarkierungsHamster(this.getReihe() + 1, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.aktIndexHamster.erlaeuterung(
      "Ich markiere jeweils den Koernerhaufen,\n" +
      "der an der richtigen Position eingefuegt werden soll.");
    this.anzahlDeponierteKoerner = 0;
  }

  // Der Standard-Hamster steht mit Blickrichtung OST irgendwo im Territorium. 
  // Ein Vertretungshamster soll die Koernerhaufen bis zur nchsten Wand in 
  // aufsteigender Reihenfolge sortieren. 
  // Voraussetzung: Unterhalb des Standard-Hamsters existieren zwei nicht 
  // durch Mauern blockierte Reihen.
  public void sortiereKoernerHaufen() {
    this.erlaeuterung(
      "Ich zaehle nun die Anzahl der zu sortierenden Koernerhaufen.");
    this.anzahlKoernerHaufen = ermittleAnzahlKoernerHaufen();
    this.erlaeuterung(
      "Die Anzahl der zu sortierenden Koernerhaufen betraegt " +
      this.anzahlKoernerHaufen +
      ",\nd.h. die Indizes der Haufen liegen zwischen 0 und " +
      (this.anzahlKoernerHaufen-1) +
      ".");

    // durchlaufe die Menge der Koernerhaufen von links nach rechts;
    // merke dir den aktuellen Koernerhaufen
    for (int aktIndex = 1; aktIndex < this.anzahlKoernerHaufen; aktIndex++) {
      this.aktIndexHamster.markiereIndex(aktIndex);
      this.erlaeuterung(
        "Ich suche nun den Einfuegeindex des " +
        "markierten Koernerhaufens bei Index " +
        this.aktIndexHamster.liefereIndex() +
        ".\nDazu deponiere ich zunaechst die " +
        this.aktIndexHamster.liefereAnzahlKoerner() +
        " Koerner des markierten Koernerhaufens.");
      this.deponiereKoerner();
      this.erlaeuterung(
        "Ich suche nun zwischen den Indizes 0 und " +
        (aktIndex-1) + 
        " den ersten Koernerhaufen von rechts,\n" +
        " der weniger oder gleich " +
        this.anzahlDeponierteKoerner +
        " Koerner besitzt.\n" +
        "Rechts von diesem befindet sich der Einfuegeindex.\n" +
        "Groessere Haufen verschiebe ich dabei jeweils " +
        "um einen Index nach rechts.");
      int einfuegeIndex = this.sucheEinfuegeIndex();
      this.erlaeuterung(
        "Einfuegeindex gefunden. Er liegt bei Index " +
        einfuegeIndex + 
        ".\nIch hole nun die deponierten Koerner und lege sie hier ab.");
      this.fuegeDeponierteKoernerEin(einfuegeIndex);
    }
    this.beendeSortierung();
  }

  private void deponiereKoerner() {
    // die Koerner werden zwei Reihen darunter deponiert
    this.laufeZuIndex(this.aktIndexHamster.liefereIndex());
    this.anzahlDeponierteKoerner = this.nimmAlle();
    this.setzeBlickrichtung(Hamster.SUED);
    this.vor(2);
    this.gib(this.anzahlDeponierteKoerner);
    this.kehrt();
    this.vor(2);
    this.linksUm();
  }

  private int sucheEinfuegeIndex() {
    // sucht und liefert den Index der Koernerhaufen, wo 
    // der aktuelle Koernerhaufen - sprich die deponierten Koerner -
    //  eingefuegt werden muss, und verschiebt alle
    // greren Koernerhaufen jeweils um eine Position nach rechts
    this.vor();
    while (this.liefereIndex() >= 0 &&
           this.liefereAnzahlKoerner() > this.anzahlDeponierteKoerner) {
      int anzahl = this.nimmAlle();
      this.kehrt();
      this.vor();
      this.gib(anzahl);
      this.kehrt();
      this.vor();
      this.vor();
    }
    return this.liefereIndex()+1;
  }

  private void fuegeDeponierteKoernerEin(int index) {
    // holt die deponierten Koerner und fuegt sie an der uebergebenen
    // Position in die Menge der Koernerhaufen ein
    this.laufeZuKachel(this.getReihe() + 2, this.aktIndexHamster.getSpalte());
    int anzahl = this.nimmAlle();
    this.laufeZuKachel(this.getReihe() - 2, this.startSpalte + index + 1);
    this.gib(anzahl);
  }

  private void beendeSortierung() {
    this.laufeZuSpalte(this.startSpalte);
    this.setzeBlickrichtung(Hamster.OST);
    this.erlaeuterung("Sortierung erfolgreich beendet!");
  }
}