import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class InsertionSort implements SortierAlgorithmus {

  // sortiert das uebergebene Array in aufsteigender Reihenfolge
  // gemaess dem InsertionSort-Algorithmus
  public void sortiere(int[] zahlen) {
    // durchlaufe alle Zahlen ab der zweiten
    for (int aktIndex=1; aktIndex<zahlen.length; aktIndex++) {
      int aktuelleZahl = zahlen[aktIndex];
      int einfuegeIndex = sucheEinfuegeIndex(zahlen, aktuelleZahl, aktIndex);
      zahlen[einfuegeIndex] = aktuelleZahl;
    }
  }
  
  // sucht und liefert den Index des Arrays, wo 
  // die aktuelle Zahl eingefuegt werden muss, und verschiebt alle
  // greren Zahlen jeweils um eine Position nach hinten im Array
  private int sucheEinfuegeIndex(int[] zahlen, int zahl, int aktIndex) {
  int vergleichsIndex = aktIndex-1;
  while (vergleichsIndex >= 0 && zahlen[vergleichsIndex] > zahl) {
    // Zahl im Array um eine Position nach hinten verschieben
    zahlen[vergleichsIndex+1] = zahlen[vergleichsIndex];
    vergleichsIndex--;
  }
  return vergleichsIndex+1;
  }
  
  /* der InsertionSort-Algorithmus in kompakter Form
  public void sortiere(int[] zahlen) {
  for (int aktIndex=1; aktIndex<zahlen.length; aktIndex++) {
    int aktuelleZahl = zahlen[aktIndex];
    int vergleichsIndex = aktIndex-1;
    while (vergleichsIndex >= 0 && zahlen[vergleichsIndex] > aktuelleZahl) {
      zahlen[vergleichsIndex+1] = zahlen[vergleichsIndex];
      vergleichsIndex--;
    }
    zahlen[vergleichsIndex+1] = aktuelleZahl;
  }
  }
  */
}
