// Demonstartion des BubbleSort-Algorithmus
import de.hamster.debugger.model.Territorium;import de.hamster.model.HamsterInitialisierungsException;import de.hamster.model.HamsterNichtInitialisiertException;import de.hamster.model.KachelLeerException;import de.hamster.model.MauerDaException;import de.hamster.model.MaulLeerException;import de.hamster.debugger.model.Hamster;public class BubbleSortHamster
  extends KoernerHaufenSortierHamster 
  implements SortierHamster {

  private MarkierungsHamster sortiertIndexHamster = null;
    // markiert das Ende des sortierten Teils

  private BooleanHamster tauschStattgefundenHamster = null;
    // zeigt an, ob in einem Durchlauf ein Tausch stattgefunden hat

  private int anzahlKoernerHaufen = 0;
    // Anzahl der zu sortierenden Koernerhaufen

  // Konstruktor
  public BubbleSortHamster(boolean mitErlaeuterungen) {
    super(mitErlaeuterungen);
    this.erlaeuterung(
      "Ich sortiere die Koernerhaufen auf der Basis des BubbleSort-Algorithmus.");
    this.sortiertIndexHamster = 
      new MarkierungsHamster(this.getReihe() + 1, this.getSpalte(),
                             this.getReihe(), mitErlaeuterungen);
    this.sortiertIndexHamster.erlaeuterung(
      "Ich markiere das Ende des sortierten Teils.");
    this.tauschStattgefundenHamster = 
      new BooleanHamster(this.getReihe() + 2, this.getSpalte(), 
                         false, mitErlaeuterungen);
    this.tauschStattgefundenHamster.erlaeuterung(
      "Ich deute an, ob in einem Durchlauf ein Tausch stattgefunden hat.");
  }

  // Der Standard-Hamster steht mit Blickrichtung OST irgendwo im Territorium. 
  // Ein Vertretungshamster soll die Koernerhaufen bis zur nchsten Wand in 
  // aufsteigender Reihenfolge sortieren. 
  // Voraussetzung: Unterhalb des Standard-Hamsters existieren zwei nicht 
  // durch Mauern blockierte Reihen.
  public void sortiereKoernerHaufen() {
    this.erlaeuterung(
      "Ich zaehle nun die Anzahl der zu sortierenden Koernerhaufen.");
    this.anzahlKoernerHaufen = this.ermittleAnzahlKoernerHaufen();
    this.erlaeuterung(
      "Die Anzahl der zu sortierenden Koernerhaufen betraegt " +
      this.anzahlKoernerHaufen +
      ",\nd.h. die Indizes der Haufen liegen zwischen 0 und " +
      (this.anzahlKoernerHaufen-1) +
      ".");

    do {
      this.tauschStattgefundenHamster.deuteAn(false);
      // laufe nach vorne bis zum Anfang des unsortierten Teils
      this.erlaeuterung(
        "Ich transportiere nun den kleinsten Koernerhaufen im unsortierten Teil," +
        "\nd.h. zwischen den Indizes " +
        (this.sortiertIndexHamster.liefereIndex()+1) + " und " +
        (anzahlKoernerHaufen-1) + ", zum Index " +
        (this.sortiertIndexHamster.liefereIndex()+1) + 
        ".");
      for (int aktIndex = anzahlKoernerHaufen-1; 
           aktIndex > this.sortiertIndexHamster.liefereIndex()+1; 
           aktIndex--) {
        this.laufeZuIndex(aktIndex);
        this.setzeBlickrichtung(Hamster.WEST);
        // vergleiche benachbarte Koernerhaufen und tausche, 
        // falls der hintere Haufen kleiner ist
        if (anzahlKoernerAktIndex() < anzahlKoernerAktIndexMinus1()) {
          this.erlaeuterung(
            "Der Koernerhaufen beim Index " + 
            aktIndex +
            " ist kleiner als der Koernerhaufen beim Index " + 
            (aktIndex-1) +
            ".\nDaher tausche ich sie.");
          koernerHaufenTauschen();
          this.tauschStattgefundenHamster.deuteAn(true);
        }
      }
      this.sortiertIndexHamster.markiereIndex(
        this.sortiertIndexHamster.liefereIndex()+1);
    } while (this.tauschStattgefundenHamster.istWahr());
    this.erlaeuterung(
      "Im letzten Durchlauf hat kein Tausch mehr stattgefunden," +
      "\nd.h. die Koernerhaufen sind sortiert.");
    beendeSortierung();
  }

  private void koernerHaufenTauschen() {
    int koernerAnzahl1 = this.nimmAlle();
    this.vor();
    int koernerAnzahl2 = this.nimmAlle();
    this.gib(koernerAnzahl1);
    this.kehrt();
    this.vor();
    this.gib(koernerAnzahl2);
  }

  private void beendeSortierung() {
    this.laufeZuSpalte(this.startSpalte);
    this.setzeBlickrichtung(Hamster.OST);
    this.erlaeuterung("Sortierung erfolgreich beendet!");
  }

  private int anzahlKoernerAktIndex() {
    return Territorium.getAnzahlKoerner(this.getReihe(), this.getSpalte());
  }

  private int anzahlKoernerAktIndexMinus1() {
    return Territorium.getAnzahlKoerner(this.getReihe(), this.getSpalte()-1);
  }
}